/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.dao;

import java.util.logging.Logger;
import tr.data.DAOProvider;
import tr.data.DAOProviderLookup;
import tr.view.actions.screens.ActionsScreens;
import tr.view.actions.screens.dao.ScreensDAO;
import tr.view.actions.screens.dao.ScreensDAOJAXB;
import tr.view.actions.screens.dao.ScreensDAOProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreensDAOProvider
implements DAOProvider<ScreensDAO> {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private static final ScreensDAOProvider instance = new ScreensDAOProvider();
    private ScreensDAO screensDAO;

    public static final ScreensDAOProvider instance() {
        return instance;
    }

    private ScreensDAOProvider() {
        DAOProviderLookup.instance().setDAOProvider((DAOProvider)this);
    }

    public ScreensDAO provide() {
        if (this.screensDAO == null) {
            this.screensDAO = this.initialiseScreensDAO();
        }
        return this.screensDAO;
    }

    private ScreensDAO initialiseScreensDAO() {
        ScreensDAO screensDAOProps;
        LOG.info("initialiseScreensDAO()");
        ScreensDAO dao = ScreensDAOJAXB.getInstance();
        if (dao.hasPersistantData()) {
            try {
                dao.restore();
                return dao;
            }
            catch (Exception ex) {
                LOG.severe("Failed to restore review actions settings. " + ex.getMessage());
            }
        }
        if ((screensDAOProps = ScreensDAOProperties.getInstance()).hasPersistantData()) {
            try {
                ((ActionsScreens)dao.getData()).setScreens(((ActionsScreens)screensDAOProps.getData()).getScreens());
                return dao;
            }
            catch (Exception ex) {
                LOG.severe("Failed to get review actions settings. " + ex.getMessage());
            }
        }
        ((ActionsScreens)dao.getData()).setScreens(ActionsScreens.createDefaultScreens());
        return dao;
    }

    public boolean isInitialised() {
        return this.screensDAO != null;
    }

    public void reset() {
        this.screensDAO = null;
    }
}

