/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import ca.odell.glazedlists.impl.adt.barcode2.BciiNode;
import ca.odell.glazedlists.impl.adt.barcode2.BciiTree;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BciiTreeIterator<V> {
    int count1;
    int count2;
    int count4;
    private BciiTree<V> tree;
    private BciiNode<V> node;
    private int index;

    public BciiTreeIterator(BciiTree<V> tree) {
        this(tree, 0, 0);
    }

    public BciiTreeIterator(BciiTree<V> tree, int nextIndex, byte nextIndexColors) {
        this.tree = tree;
        if (nextIndex != 0) {
            int currentIndex = nextIndex - 1;
            this.node = (BciiNode)tree.get(currentIndex, nextIndexColors);
            this.count1 = tree.convertIndexColor(currentIndex, nextIndexColors, (byte)1) + (this.node.color == 1 ? 0 : 1);
            this.count2 = tree.convertIndexColor(currentIndex, nextIndexColors, (byte)2) + (this.node.color == 2 ? 0 : 1);
            this.count4 = tree.convertIndexColor(currentIndex, nextIndexColors, (byte)4) + (this.node.color == 4 ? 0 : 1);
            if (this.node.color == 1) {
                this.index = this.count1 - tree.indexOfNode(this.node, (byte)1);
            }
            if (this.node.color == 2) {
                this.index = this.count2 - tree.indexOfNode(this.node, (byte)2);
            }
            if (this.node.color == 4) {
                this.index = this.count4 - tree.indexOfNode(this.node, (byte)4);
            }
        } else {
            this.node = null;
            this.index = 0;
        }
    }

    public BciiTreeIterator<V> copy() {
        BciiTreeIterator<V> result = new BciiTreeIterator<V>(this.tree);
        result.count1 = this.count1;
        result.count2 = this.count2;
        result.count4 = this.count4;
        result.node = this.node;
        result.index = this.index;
        return result;
    }

    public boolean hasNext(byte colors) {
        if (this.node == null) {
            return this.tree.size(colors) > 0;
        }
        if ((colors & this.node.color) != 0) {
            return this.index(colors) < this.tree.size(colors) - 1;
        }
        return this.index(colors) < this.tree.size(colors);
    }

    public boolean hasNextNode(byte colors) {
        if (this.node == null) {
            return this.tree.size(colors) > 0;
        }
        return this.nodeEndIndex(colors) < this.tree.size(colors);
    }

    public void next(byte colors) {
        if (!this.hasNext(colors)) {
            throw new NoSuchElementException();
        }
        if (this.node == null) {
            this.node = this.tree.firstNode();
            this.index = 0;
            if ((this.node.color & colors) != 0) {
                return;
            }
        } else if ((this.node.color & colors) != 0 && this.index < this.node.size - 1) {
            if (this.node.color == 1) {
                ++this.count1;
            }
            if (this.node.color == 2) {
                ++this.count2;
            }
            if (this.node.color == 4) {
                ++this.count4;
            }
            ++this.index;
            return;
        }
        do {
            if (this.node.color == 1) {
                this.count1 += this.node.size - this.index;
            }
            if (this.node.color == 2) {
                this.count2 += this.node.size - this.index;
            }
            if (this.node.color == 4) {
                this.count4 += this.node.size - this.index;
            }
            this.node = BciiTree.next(this.node);
            this.index = 0;
        } while ((this.node.color & colors) == 0);
    }

    public void nextNode(byte colors) {
        if (!this.hasNextNode(colors)) {
            throw new NoSuchElementException();
        }
        if (this.node == null) {
            this.node = this.tree.firstNode();
            this.index = 0;
            if ((this.node.color & colors) != 0) {
                return;
            }
        }
        do {
            if (this.node.color == 1) {
                this.count1 += this.node.size - this.index;
            }
            if (this.node.color == 2) {
                this.count2 += this.node.size - this.index;
            }
            if (this.node.color == 4) {
                this.count4 += this.node.size - this.index;
            }
            this.node = BciiTree.next(this.node);
            this.index = 0;
        } while ((this.node.color & colors) == 0);
    }

    public int nodeSize(byte colors) {
        if ((this.node.color & colors) != 0) {
            return this.node.size;
        }
        return 0;
    }

    public byte color() {
        if (this.node == null) {
            throw new IllegalStateException();
        }
        return this.node.color;
    }

    public int index(byte colors) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        int result = 0;
        if ((colors & 1) != 0) {
            result += this.count1;
        }
        if ((colors & 2) != 0) {
            result += this.count2;
        }
        if ((colors & 4) != 0) {
            result += this.count4;
        }
        return result;
    }

    public int nodeStartIndex(byte colors) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        int result = 0;
        if ((colors & 1) != 0) {
            result += this.count1;
        }
        if ((colors & 2) != 0) {
            result += this.count2;
        }
        if ((colors & 4) != 0) {
            result += this.count4;
        }
        if ((this.node.color & colors) != 0) {
            result -= this.index;
        }
        return result;
    }

    public int nodeEndIndex(byte colors) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        return this.nodeStartIndex(colors) + this.nodeSize(colors);
    }

    public V value() {
        if (this.node == null) {
            throw new IllegalStateException();
        }
        return this.node.get();
    }

    public Element<V> node() {
        if (this.node == null) {
            throw new IllegalStateException();
        }
        return this.node;
    }
}

