/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class Pool<T> {
    private final Queue<T> store = this.createStore();

    public Pool() {
    }

    public Pool(int initialSize) {
        this();
        this.preCreate(initialSize);
    }

    public void checkin(T object) {
        if (object != null) {
            this.clear(object);
            this.store.offer(object);
        }
    }

    public T checkout() {
        T result = this.store.poll();
        if (result == null) {
            result = this.createObject();
        }
        return result;
    }

    public void clear() {
        this.getStore().clear();
    }

    protected void clear(T object) {
    }

    protected abstract T createObject();

    protected Queue<T> createStore() {
        return new ConcurrentLinkedQueue();
    }

    protected Queue<T> getStore() {
        return this.store;
    }

    public void preCreate(int initialSize) {
        for (int i = 0; i < initialSize; ++i) {
            this.checkin(this.createObject());
        }
    }
}

