/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.CursorImpl;
import com.healthmarketscience.jackcess.impl.IndexCursorImpl;
import com.healthmarketscience.jackcess.impl.IndexData;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.util.ColumnMatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CursorBuilder {
    private final TableImpl _table;
    private IndexImpl _index;
    private Object[] _startRow;
    private boolean _startRowInclusive = true;
    private Object[] _endRow;
    private boolean _endRowInclusive = true;
    private boolean _beforeFirst = true;
    private Cursor.Savepoint _savepoint;
    private ColumnMatcher _columnMatcher;

    public CursorBuilder(Table table) {
        this._table = (TableImpl)table;
    }

    public CursorBuilder beforeFirst() {
        this._beforeFirst = true;
        return this;
    }

    public CursorBuilder afterLast() {
        this._beforeFirst = false;
        return this;
    }

    public CursorBuilder restoreSavepoint(Cursor.Savepoint savepoint) {
        this._savepoint = savepoint;
        return this;
    }

    public CursorBuilder setIndex(Index index) {
        this._index = (IndexImpl)index;
        return this;
    }

    public CursorBuilder setIndexByName(String indexName) {
        return this.setIndex(this._table.getIndex(indexName));
    }

    public CursorBuilder setIndexByColumnNames(String ... columnNames) {
        return this.setIndexByColumns(Arrays.asList(columnNames));
    }

    public CursorBuilder setIndexByColumns(Column ... columns) {
        ArrayList<String> colNames = new ArrayList<String>();
        for (Column col : columns) {
            colNames.add(col.getName());
        }
        return this.setIndexByColumns(colNames);
    }

    private CursorBuilder setIndexByColumns(List<String> searchColumns) {
        IndexImpl index = this._table.findIndexForColumns(searchColumns, TableImpl.IndexFeature.ANY_MATCH);
        if (index == null) {
            throw new IllegalArgumentException("Index with columns " + searchColumns + " does not exist in table " + this._table);
        }
        this._index = index;
        return this;
    }

    public CursorBuilder setSpecificRow(Object ... specificRow) {
        this.setStartRow(specificRow);
        this.setEndRow(specificRow);
        return this;
    }

    public CursorBuilder setSpecificEntry(Object ... specificEntry) {
        if (specificEntry != null) {
            this.setSpecificRow(this._index.constructIndexRowFromEntry(specificEntry));
        }
        return this;
    }

    public CursorBuilder setStartRow(Object ... startRow) {
        this._startRow = startRow;
        return this;
    }

    public CursorBuilder setStartEntry(Object ... startEntry) {
        if (startEntry != null) {
            this.setStartRow(this._index.constructPartialIndexRowFromEntry(IndexData.MIN_VALUE, startEntry));
        }
        return this;
    }

    public CursorBuilder setStartRowInclusive(boolean inclusive) {
        this._startRowInclusive = inclusive;
        return this;
    }

    public CursorBuilder setEndRow(Object ... endRow) {
        this._endRow = endRow;
        return this;
    }

    public CursorBuilder setEndEntry(Object ... endEntry) {
        if (endEntry != null) {
            this.setEndRow(this._index.constructPartialIndexRowFromEntry(IndexData.MAX_VALUE, endEntry));
        }
        return this;
    }

    public CursorBuilder setEndRowInclusive(boolean inclusive) {
        this._endRowInclusive = inclusive;
        return this;
    }

    public CursorBuilder setColumnMatcher(ColumnMatcher columnMatcher) {
        this._columnMatcher = columnMatcher;
        return this;
    }

    public Cursor toCursor() throws IOException {
        CursorImpl cursor = null;
        cursor = this._index == null ? CursorImpl.createCursor(this._table) : IndexCursorImpl.createCursor(this._table, this._index, this._startRow, this._startRowInclusive, this._endRow, this._endRowInclusive);
        cursor.setColumnMatcher(this._columnMatcher);
        if (this._savepoint == null) {
            if (!this._beforeFirst) {
                cursor.afterLast();
            }
        } else {
            cursor.restoreSavepoint(this._savepoint);
        }
        return cursor;
    }

    public IndexCursor toIndexCursor() throws IOException {
        return (IndexCursorImpl)this.toCursor();
    }

    public static Cursor createCursor(Table table) throws IOException {
        return table.newCursor().toCursor();
    }

    public static IndexCursor createCursor(Index index) throws IOException {
        return index.getTable().newCursor().setIndex(index).toIndexCursor();
    }

    public static IndexCursor createPrimaryKeyCursor(Table table) throws IOException {
        return CursorBuilder.createCursor(table.getPrimaryKeyIndex());
    }

    public static IndexCursor createCursor(Index index, Object[] startRow, Object[] endRow) throws IOException {
        return index.getTable().newCursor().setIndex(index).setStartRow(startRow).setEndRow(endRow).toIndexCursor();
    }

    public static IndexCursor createCursor(Index index, Object[] startRow, boolean startInclusive, Object[] endRow, boolean endInclusive) throws IOException {
        return index.getTable().newCursor().setIndex(index).setStartRow(startRow).setStartRowInclusive(startInclusive).setEndRow(endRow).setEndRowInclusive(endInclusive).toIndexCursor();
    }

    public static Row findRow(Table table, Map<String, ?> rowPattern) throws IOException {
        Cursor cursor = CursorBuilder.createCursor(table);
        if (cursor.findFirstRow(rowPattern)) {
            return cursor.getCurrentRow();
        }
        return null;
    }

    public static Row findRowByEntry(Index index, Object ... entryValues) throws IOException {
        return CursorBuilder.createCursor(index).findRowByEntry(entryValues);
    }

    public static Row findRowByPrimaryKey(Table table, Object ... entryValues) throws IOException {
        return CursorBuilder.findRowByEntry(table.getPrimaryKeyIndex(), entryValues);
    }

    public static Object findValue(Table table, Column column, Column columnPattern, Object valuePattern) throws IOException {
        Cursor cursor = CursorBuilder.createCursor(table);
        if (cursor.findFirstRow(columnPattern, valuePattern)) {
            return cursor.getCurrentRowValue(column);
        }
        return null;
    }

    public static Row findRow(Index index, Map<String, ?> rowPattern) throws IOException {
        IndexCursor cursor = CursorBuilder.createCursor(index);
        if (cursor.findFirstRow(rowPattern)) {
            return cursor.getCurrentRow();
        }
        return null;
    }

    public static Object findValue(Index index, Column column, Column columnPattern, Object valuePattern) throws IOException {
        IndexCursor cursor = CursorBuilder.createCursor(index);
        if (cursor.findFirstRow(columnPattern, valuePattern)) {
            return cursor.getCurrentRowValue(column);
        }
        return null;
    }
}

