/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.collector;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.prometheus.collector.CollectionsCollector;
import org.apache.solr.prometheus.collector.MetricCollector;
import org.apache.solr.prometheus.collector.MetricsCollector;
import org.apache.solr.prometheus.collector.PingCollector;
import org.apache.solr.prometheus.collector.SchedulerMetricsCollector;
import org.apache.solr.prometheus.collector.SearchCollector;
import org.apache.solr.prometheus.exporter.MetricsConfiguration;
import org.apache.solr.prometheus.exporter.MetricsQuery;
import org.apache.solr.prometheus.scraper.SolrScraper;

public class MetricsCollectorFactory {
    private final MetricsConfiguration metricsConfiguration;
    private final Executor executor;
    private final int refreshInSeconds;
    private final SolrScraper solrScraper;

    public MetricsCollectorFactory(Executor executor, int refreshInSeconds, SolrScraper solrScraper, MetricsConfiguration metricsConfiguration) {
        this.executor = executor;
        this.refreshInSeconds = refreshInSeconds;
        this.solrScraper = solrScraper;
        this.metricsConfiguration = metricsConfiguration;
    }

    public SchedulerMetricsCollector create() {
        Stream<MetricCollector> pings = this.metricsConfiguration.getPingConfiguration().stream().map(query -> new PingCollector(this.solrScraper, (MetricsQuery)query));
        Stream<MetricCollector> metrics = this.metricsConfiguration.getMetricsConfiguration().stream().map(query -> new MetricsCollector(this.solrScraper, (MetricsQuery)query));
        Stream<MetricCollector> searches = this.metricsConfiguration.getSearchConfiguration().stream().map(query -> new SearchCollector(this.solrScraper, (MetricsQuery)query));
        Stream<MetricCollector> collections = this.metricsConfiguration.getCollectionsConfiguration().stream().map(query -> new CollectionsCollector(this.solrScraper, (MetricsQuery)query));
        List<MetricCollector> collectors = Stream.of(pings, metrics, searches, collections).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
        return new SchedulerMetricsCollector(this.executor, this.refreshInSeconds, TimeUnit.SECONDS, collectors);
    }
}

