/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) != vec2(-0.1, -1.2)) => false
 * (vec2(-0.1, -1.2) != vec2(-0.42, 0.48)) => true
 * (vec2(-0.42, 0.48) != vec2(-0.1, -1.2)) => true
 * (vec2(-0.42, 0.48) != vec2(-0.42, 0.48)) => false
 */
#version 150

void main()
{
  float[(vec2(-0.1, -1.2) != vec2(-0.1, -1.2)) == false ? 1 : -1] array0;
  float[(vec2(-0.1, -1.2) != vec2(-0.42, 0.48)) == true ? 1 : -1] array1;
  float[(vec2(-0.42, 0.48) != vec2(-0.1, -1.2)) == true ? 1 : -1] array2;
  float[(vec2(-0.42, 0.48) != vec2(-0.42, 0.48)) == false ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
