/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u % uvec3(36u, 32u, 88u)) => uvec3(0u, 0u, 0u)
 * (0u % uvec3(59u, 77u, 68u)) => uvec3(0u, 0u, 0u)
 * (6u % uvec3(36u, 32u, 88u)) => uvec3(6u, 6u, 6u)
 * (6u % uvec3(59u, 77u, 68u)) => uvec3(6u, 6u, 6u)
 * (12u % uvec3(36u, 32u, 88u)) => uvec3(12u, 12u, 12u)
 * (12u % uvec3(59u, 77u, 68u)) => uvec3(12u, 12u, 12u)
 * (32u % uvec3(36u, 32u, 88u)) => uvec3(32u, 0u, 32u)
 * (32u % uvec3(59u, 77u, 68u)) => uvec3(32u, 32u, 32u)
 * (74u % uvec3(36u, 32u, 88u)) => uvec3(2u, 10u, 74u)
 * (74u % uvec3(59u, 77u, 68u)) => uvec3(15u, 74u, 6u)
 */
#version 130

void main()
{
  float[all(equal((0u % uvec3(36u, 32u, 88u)), uvec3(0u, 0u, 0u))) ? 1 : -1] array0;
  float[all(equal((0u % uvec3(59u, 77u, 68u)), uvec3(0u, 0u, 0u))) ? 1 : -1] array1;
  float[all(equal((6u % uvec3(36u, 32u, 88u)), uvec3(6u, 6u, 6u))) ? 1 : -1] array2;
  float[all(equal((6u % uvec3(59u, 77u, 68u)), uvec3(6u, 6u, 6u))) ? 1 : -1] array3;
  float[all(equal((12u % uvec3(36u, 32u, 88u)), uvec3(12u, 12u, 12u))) ? 1 : -1] array4;
  float[all(equal((12u % uvec3(59u, 77u, 68u)), uvec3(12u, 12u, 12u))) ? 1 : -1] array5;
  float[all(equal((32u % uvec3(36u, 32u, 88u)), uvec3(32u, 0u, 32u))) ? 1 : -1] array6;
  float[all(equal((32u % uvec3(59u, 77u, 68u)), uvec3(32u, 32u, 32u))) ? 1 : -1] array7;
  float[all(equal((74u % uvec3(36u, 32u, 88u)), uvec3(2u, 10u, 74u))) ? 1 : -1] array8;
  float[all(equal((74u % uvec3(59u, 77u, 68u)), uvec3(15u, 74u, 6u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
