/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * ceil(-2.0) => -2.0
 * ceil(-0.6666667) => -0.0
 * ceil(0.6666667) => 1.0
 * ceil(2.0) => 2.0
 */
#version 120

void main()
{
  float[distance(ceil(-2.0), -2.0) <= 2e-05 ? 1 : -1] array0;
  float[distance(ceil(-0.6666667), -0.0) <= 0.0 ? 1 : -1] array1;
  float[distance(ceil(0.6666667), 1.0) <= 1e-05 ? 1 : -1] array2;
  float[distance(ceil(2.0), 2.0) <= 2e-05 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
