/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;

class CacheUtils {
    CacheUtils() {
    }

    public static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public static int pluginHashCode(Plugin plugin) {
        int hash = 17;
        hash = hash * 31 + CacheUtils.hash(plugin.getGroupId());
        hash = hash * 31 + CacheUtils.hash(plugin.getArtifactId());
        hash = hash * 31 + CacheUtils.hash(plugin.getVersion());
        hash = hash * 31 + (plugin.isExtensions() ? 1 : 0);
        for (Dependency dependency : plugin.getDependencies()) {
            hash = hash * 31 + CacheUtils.hash(dependency.getGroupId());
            hash = hash * 31 + CacheUtils.hash(dependency.getArtifactId());
            hash = hash * 31 + CacheUtils.hash(dependency.getVersion());
            hash = hash * 31 + CacheUtils.hash(dependency.getType());
            hash = hash * 31 + CacheUtils.hash(dependency.getClassifier());
            hash = hash * 31 + CacheUtils.hash(dependency.getScope());
            for (Exclusion exclusion : dependency.getExclusions()) {
                hash = hash * 31 + CacheUtils.hash(exclusion.getGroupId());
                hash = hash * 31 + CacheUtils.hash(exclusion.getArtifactId());
            }
        }
        return hash;
    }

    public static boolean pluginEquals(Plugin a, Plugin b) {
        return CacheUtils.eq(a.getArtifactId(), b.getArtifactId()) && CacheUtils.eq(a.getGroupId(), b.getGroupId()) && CacheUtils.eq(a.getVersion(), b.getVersion()) && a.isExtensions() == b.isExtensions() && CacheUtils.dependenciesEquals(a.getDependencies(), b.getDependencies());
    }

    private static boolean dependenciesEquals(List<Dependency> a, List<Dependency> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Dependency> aI = a.iterator();
        Iterator<Dependency> bI = b.iterator();
        while (aI.hasNext()) {
            boolean r;
            Dependency aD = aI.next();
            Dependency bD = bI.next();
            boolean bl = r = CacheUtils.eq(aD.getGroupId(), bD.getGroupId()) && CacheUtils.eq(aD.getArtifactId(), bD.getArtifactId()) && CacheUtils.eq(aD.getVersion(), bD.getVersion()) && CacheUtils.eq(aD.getType(), bD.getType()) && CacheUtils.eq(aD.getClassifier(), bD.getClassifier()) && CacheUtils.eq(aD.getScope(), bD.getScope());
            if (r &= CacheUtils.exclusionsEquals(aD.getExclusions(), bD.getExclusions())) continue;
            return false;
        }
        return true;
    }

    private static boolean exclusionsEquals(List<Exclusion> a, List<Exclusion> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Exclusion> aI = a.iterator();
        Iterator<Exclusion> bI = b.iterator();
        while (aI.hasNext()) {
            Exclusion aD = aI.next();
            Exclusion bD = bI.next();
            boolean r = CacheUtils.eq(aD.getGroupId(), bD.getGroupId()) && CacheUtils.eq(aD.getArtifactId(), bD.getArtifactId());
            if (r) continue;
            return false;
        }
        return true;
    }
}

