/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.uaparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logstash.uaparser.UserAgent;

final class UserAgentParser {
    private static final UserAgent OTHER = new UserAgent("Other", null, null, null);
    private final List<UAPattern> patterns;

    public UserAgentParser(List<UAPattern> patterns) {
        this.patterns = patterns;
    }

    public static UserAgentParser fromList(List<Map<String, String>> configList) {
        ArrayList<UAPattern> configPatterns = new ArrayList<UAPattern>();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(UserAgentParser.patternFromMap(configMap));
        }
        return new UserAgentParser(configPatterns);
    }

    public UserAgent parse(String agentString) {
        if (agentString == null) {
            return null;
        }
        for (UAPattern p : this.patterns) {
            UserAgent agent = p.match(agentString);
            if (agent == null) continue;
            return agent;
        }
        return OTHER;
    }

    private static UAPattern patternFromMap(Map<String, String> configMap) {
        String regex = configMap.get("regex");
        if (regex == null) {
            throw new IllegalArgumentException("User agent is missing regex");
        }
        return new UAPattern(Pattern.compile(regex), configMap.get("family_replacement"), configMap.get("v1_replacement"), configMap.get("v2_replacement"));
    }

    private static final class UAPattern {
        private static final Pattern FIRST_PATTERN = Pattern.compile("\\$1");
        private final Matcher matcher;
        private final boolean familyContainsPos;
        private final String familyReplacement;
        private final String v1Replacement;
        private final String v2Replacement;

        UAPattern(Pattern pattern, String familyReplacement, String v1Replacement, String v2Replacement) {
            this.matcher = pattern.matcher("");
            this.familyReplacement = familyReplacement;
            this.v1Replacement = v1Replacement;
            this.v2Replacement = v2Replacement;
            this.familyContainsPos = this.familyReplacement == null ? false : this.familyReplacement.contains("$1");
        }

        public synchronized UserAgent match(CharSequence agentString) {
            String group2;
            this.matcher.reset(agentString);
            if (!this.matcher.find()) {
                return null;
            }
            int groupCount = this.matcher.groupCount();
            String family = null;
            if (this.familyReplacement != null) {
                family = this.familyContainsPos && groupCount >= 1 && this.matcher.group(1) != null ? FIRST_PATTERN.matcher(this.familyReplacement).replaceFirst(Matcher.quoteReplacement(this.matcher.group(1))) : this.familyReplacement;
            } else if (groupCount >= 1) {
                family = this.matcher.group(1);
            }
            String v1 = null;
            if (this.v1Replacement != null) {
                v1 = this.v1Replacement;
            } else if (groupCount >= 2 && !this.isBlank(group2 = this.matcher.group(2))) {
                v1 = group2;
            }
            String v3 = null;
            String v2 = null;
            if (this.v2Replacement != null) {
                v2 = this.v2Replacement;
            } else if (groupCount >= 3) {
                String group4;
                String group3 = this.matcher.group(3);
                if (!this.isBlank(group3)) {
                    v2 = group3;
                }
                if (groupCount >= 4 && !this.isBlank(group4 = this.matcher.group(4))) {
                    v3 = group4;
                }
            }
            return family == null ? null : new UserAgent(family, v1, v2, v3);
        }

        private boolean isBlank(String value) {
            return value == null || value.isEmpty();
        }
    }
}

