/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class GVarAliasInstr
extends TwoOperandInstr
implements FixedArityInstr {
    public GVarAliasInstr(Operand newName, Operand oldName) {
        super(Operation.GVAR_ALIAS, newName, oldName);
    }

    public Operand getNewName() {
        return this.getOperand1();
    }

    public Operand getOldName() {
        return this.getOperand2();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new GVarAliasInstr(this.getNewName().cloneForInlining(ii), this.getOldName().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getNewName());
        e.encode(this.getOldName());
    }

    public static GVarAliasInstr decode(IRReaderDecoder d) {
        return new GVarAliasInstr(d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        String newNameString = this.getNewName().retrieve(context, self2, currScope, currDynScope, temp).toString();
        String oldNameString = this.getOldName().retrieve(context, self2, currScope, currDynScope, temp).toString();
        context.runtime.getGlobalVariables().alias(newNameString, oldNameString);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.GVarAliasInstr(this);
    }
}

