/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ext;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.MapJavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.ConvertedMap;
import org.logstash.Event;
import org.logstash.FieldReference;
import org.logstash.RubyUtil;
import org.logstash.Rubyfier;
import org.logstash.Valuefier;
import org.logstash.ext.JrubyTimestampExtLibrary;

public final class JrubyEventExtLibrary {

    @JRubyClass(name={"Event"})
    public static final class RubyEvent
    extends RubyObject {
        private static final long serialVersionUID = 1L;
        private static final AtomicLong SEQUENCE_GENERATOR = new AtomicLong(1L);
        private final int hash = RubyEvent.nextHash();
        private Event event;

        public RubyEvent(Ruby runtime, RubyClass klass) {
            super(runtime, klass);
        }

        public static RubyEvent newRubyEvent(Ruby runtime) {
            return RubyEvent.newRubyEvent(runtime, new Event());
        }

        public static RubyEvent newRubyEvent(Ruby runtime, Event event) {
            RubyEvent ruby = new RubyEvent(runtime, RubyUtil.RUBY_EVENT_CLASS);
            ruby.setEvent(event);
            return ruby;
        }

        public Event getEvent() {
            return this.event;
        }

        @JRubyMethod(name={"initialize"}, optional=1)
        public IRubyObject ruby_initialize(ThreadContext context, IRubyObject[] args) {
            IRubyObject data;
            IRubyObject iRubyObject = data = args.length > 0 ? args[0] : null;
            if (data instanceof RubyHash) {
                this.event = new Event(ConvertedMap.newFromRubyHash(context, (RubyHash)data));
            } else if (data != null && data.getJavaClass().equals(Event.class)) {
                this.event = (Event)data.toJava(Event.class);
            } else {
                this.initializeFallback(context, data);
            }
            return context.nil;
        }

        @JRubyMethod(name={"get"}, required=1)
        public IRubyObject ruby_get_field(ThreadContext context, RubyString reference) {
            return Rubyfier.deep(context.runtime, this.event.getUnconvertedField(RubyEvent.extractFieldReference(reference)));
        }

        @JRubyMethod(name={"set"}, required=2)
        public IRubyObject ruby_set_field(ThreadContext context, RubyString reference, IRubyObject value) {
            FieldReference r = RubyEvent.extractFieldReference(reference);
            if (r.equals(FieldReference.TIMESTAMP_REFERENCE)) {
                if (!(value instanceof JrubyTimestampExtLibrary.RubyTimestamp)) {
                    throw context.runtime.newTypeError("wrong argument type " + value.getMetaClass() + " (expected LogStash::Timestamp)");
                }
                this.event.setTimestamp(((JrubyTimestampExtLibrary.RubyTimestamp)value).getTimestamp());
            } else {
                this.event.setField(r, RubyEvent.safeValueifierConvert(value));
            }
            return value;
        }

        @JRubyMethod(name={"cancel"})
        public IRubyObject ruby_cancel(ThreadContext context) {
            this.event.cancel();
            return context.runtime.getTrue();
        }

        @JRubyMethod(name={"uncancel"})
        public IRubyObject ruby_uncancel(ThreadContext context) {
            this.event.uncancel();
            return context.runtime.getFalse();
        }

        @JRubyMethod(name={"cancelled?"})
        public IRubyObject ruby_cancelled(ThreadContext context) {
            return RubyBoolean.newBoolean((Ruby)context.runtime, (boolean)this.event.isCancelled());
        }

        @JRubyMethod(name={"include?"}, required=1)
        public IRubyObject ruby_includes(ThreadContext context, RubyString reference) {
            return RubyBoolean.newBoolean((Ruby)context.runtime, (boolean)this.event.includes(RubyEvent.extractFieldReference(reference)));
        }

        @JRubyMethod(name={"remove"}, required=1)
        public IRubyObject ruby_remove(ThreadContext context, RubyString reference) {
            return Rubyfier.deep(context.runtime, this.event.remove(RubyEvent.extractFieldReference(reference)));
        }

        @JRubyMethod(name={"clone"})
        public IRubyObject rubyClone(ThreadContext context) {
            return this.rubyClone(context.runtime);
        }

        public RubyEvent rubyClone(Ruby runtime) {
            return RubyEvent.newRubyEvent(runtime, this.event.clone());
        }

        @JRubyMethod(name={"overwrite"}, required=1)
        public IRubyObject ruby_overwrite(ThreadContext context, IRubyObject value) {
            if (!(value instanceof RubyEvent)) {
                throw context.runtime.newTypeError("wrong argument type " + value.getMetaClass() + " (expected LogStash::Event)");
            }
            return RubyEvent.newRubyEvent(context.runtime, this.event.overwrite(((RubyEvent)value).event));
        }

        @JRubyMethod(name={"append"}, required=1)
        public IRubyObject ruby_append(ThreadContext context, IRubyObject value) {
            if (!(value instanceof RubyEvent)) {
                throw context.runtime.newTypeError("wrong argument type " + value.getMetaClass() + " (expected LogStash::Event)");
            }
            this.event.append(((RubyEvent)value).getEvent());
            return this;
        }

        @JRubyMethod(name={"sprintf"}, required=1)
        public IRubyObject ruby_sprintf(ThreadContext context, IRubyObject format) {
            try {
                return RubyString.newString((Ruby)context.runtime, (String)this.event.sprintf(format.toString()));
            }
            catch (IOException e) {
                throw RaiseException.from((Ruby)this.getRuntime(), (RubyClass)RubyUtil.LOGSTASH_ERROR, (String)"timestamp field is missing");
            }
        }

        @JRubyMethod(name={"to_s"})
        public IRubyObject ruby_to_s(ThreadContext context) {
            return RubyString.newString((Ruby)context.runtime, (String)this.event.toString());
        }

        @JRubyMethod(name={"to_hash"})
        public IRubyObject ruby_to_hash(ThreadContext context) {
            return Rubyfier.deep(context.runtime, this.event.getData());
        }

        @JRubyMethod(name={"to_hash_with_metadata"})
        public IRubyObject ruby_to_hash_with_metadata(ThreadContext context) {
            Map<String, Object> data = this.event.toMap();
            ConvertedMap metadata = this.event.getMetadata();
            if (!metadata.isEmpty()) {
                data.put("@metadata", metadata);
            }
            return Rubyfier.deep(context.runtime, data);
        }

        @JRubyMethod(name={"to_java"})
        public IRubyObject ruby_to_java(ThreadContext context) {
            return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)this.event);
        }

        @JRubyMethod(name={"to_json"}, rest=true)
        public IRubyObject ruby_to_json(ThreadContext context, IRubyObject[] args) {
            try {
                return RubyString.newString((Ruby)context.runtime, (String)this.event.toJson());
            }
            catch (Exception e) {
                throw RaiseException.from((Ruby)context.runtime, (RubyClass)RubyUtil.GENERATOR_ERROR, (String)e.getMessage());
            }
        }

        @JRubyMethod(name={"from_json"}, required=1, meta=true)
        public static IRubyObject ruby_from_json(ThreadContext context, IRubyObject recv, RubyString value) {
            Event[] events;
            try {
                events = Event.fromJson(value.asJavaString());
            }
            catch (Exception e) {
                throw RaiseException.from((Ruby)context.runtime, (RubyClass)RubyUtil.PARSER_ERROR, (String)e.getMessage());
            }
            RubyArray result = RubyArray.newArray((Ruby)context.runtime, (int)events.length);
            if (events.length == 1) {
                result.set(0, (Object)RubyEvent.newRubyEvent(context.runtime, events[0]));
            } else {
                for (int i = 0; i < events.length; ++i) {
                    result.set(i, (Object)RubyEvent.newRubyEvent(context.runtime, events[i]));
                }
            }
            return result;
        }

        @JRubyMethod(name={"validate_value"}, required=1, meta=true)
        public static IRubyObject ruby_validate_value(ThreadContext context, IRubyObject recv, IRubyObject value) {
            return value;
        }

        @JRubyMethod(name={"tag"}, required=1)
        public IRubyObject ruby_tag(ThreadContext context, RubyString value) {
            this.event.tag(value.asJavaString());
            return context.nil;
        }

        @JRubyMethod(name={"timestamp"})
        public IRubyObject ruby_timestamp(ThreadContext context) {
            return (IRubyObject)this.event.getUnconvertedField(FieldReference.TIMESTAMP_REFERENCE);
        }

        @JRubyMethod(name={"timestamp="}, required=1)
        public IRubyObject ruby_set_timestamp(ThreadContext context, IRubyObject value) {
            if (!(value instanceof JrubyTimestampExtLibrary.RubyTimestamp)) {
                throw context.runtime.newTypeError("wrong argument type " + value.getMetaClass() + " (expected LogStash::Timestamp)");
            }
            this.event.setTimestamp(((JrubyTimestampExtLibrary.RubyTimestamp)value).getTimestamp());
            return value;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object that) {
            return this == that;
        }

        private void initializeFallback(ThreadContext context, IRubyObject data) {
            if (data == null || data.isNil()) {
                this.event = new Event();
            } else if (data instanceof MapJavaProxy) {
                this.event = new Event(ConvertedMap.newFromMap((Map)((MapJavaProxy)data).getObject()));
            } else {
                throw context.runtime.newTypeError("wrong argument type " + data.getMetaClass() + " (expected Hash)");
            }
        }

        private static FieldReference extractFieldReference(RubyString reference) {
            try {
                return FieldReference.from(reference);
            }
            catch (FieldReference.IllegalSyntaxException ise) {
                throw RubyUtil.RUBY.newRuntimeError(ise.getMessage());
            }
        }

        private static Object safeValueifierConvert(Object value) {
            try {
                return Valuefier.convert(value);
            }
            catch (FieldReference.IllegalSyntaxException ise) {
                throw RubyUtil.RUBY.newRuntimeError(ise.getMessage());
            }
        }

        private void setEvent(Event event) {
            this.event = event;
        }

        private static int nextHash() {
            long sequence = SEQUENCE_GENERATOR.incrementAndGet();
            return (int)(sequence ^ sequence >>> 32) + 31;
        }
    }
}

