"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleKibanaStats = handleKibanaStats;
exports.getKibana = getKibana;

var _lodash = require("lodash");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function handleKibanaStats(server, response) {
  if (!response) {
    server.log(['warning', 'telemetry', 'local-stats'], 'No Kibana stats returned from usage collectors');
    return;
  }

  const {
    kibana,
    kibana_stats: kibanaStats,
    ...plugins
  } = response;
  const platform = (0, _lodash.get)(kibanaStats, 'os.platform', 'unknown');
  const platformRelease = (0, _lodash.get)(kibanaStats, 'os.platformRelease', 'unknown');
  const version = server.config().get('pkg.version').replace(/-snapshot/i, ''); // combine core stats (os types, saved objects) with plugin usage stats
  // organize the object into the same format as monitoring-enabled telemetry

  return { ...(0, _lodash.omit)(kibana, 'index'),
    // discard index
    count: 1,
    indices: 1,
    os: {
      platforms: [{
        platform,
        count: 1
      }],
      platformReleases: [{
        platformRelease,
        count: 1
      }]
    },
    versions: [{
      version,
      count: 1
    }],
    plugins
  };
}

async function getKibana(usageCollection, callWithInternalUser) {
  const usage = await usageCollection.bulkFetch(callWithInternalUser);
  return usageCollection.toObject(usage);
}