"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../commons");
var light_theme_1 = require("./light_theme");
exports.DEFAULT_ANNOTATION_LINE_STYLE = {
    line: {
        stroke: '#777',
        strokeWidth: 1,
        opacity: 1,
    },
    details: {
        fontSize: 10,
        fontFamily: 'sans-serif',
        fontStyle: 'normal',
        fill: '#777',
        padding: 0,
    },
};
exports.DEFAULT_ANNOTATION_RECT_STYLE = {
    stroke: '#FFEEBC',
    strokeWidth: 0,
    opacity: 0.25,
    fill: '#FFEEBC',
};
function mergeGridLineConfigs(axisSpecConfig, themeConfig) {
    var visible = axisSpecConfig.visible != null ? axisSpecConfig.visible : themeConfig.visible;
    var strokeWidth = axisSpecConfig.strokeWidth != null ? axisSpecConfig.strokeWidth : themeConfig.strokeWidth;
    var opacity = axisSpecConfig.opacity != null ? axisSpecConfig.opacity : themeConfig.opacity;
    return {
        visible: visible,
        stroke: axisSpecConfig.stroke || themeConfig.stroke,
        dash: axisSpecConfig.dash || themeConfig.dash,
        strokeWidth: strokeWidth,
        opacity: opacity,
    };
}
exports.mergeGridLineConfigs = mergeGridLineConfigs;
function mergeWithDefaultAnnotationLine(config) {
    var defaultLine = exports.DEFAULT_ANNOTATION_LINE_STYLE.line;
    var defaultDetails = exports.DEFAULT_ANNOTATION_LINE_STYLE.details;
    var mergedConfig = __assign({}, exports.DEFAULT_ANNOTATION_LINE_STYLE);
    if (!config) {
        return mergedConfig;
    }
    if (config.line) {
        mergedConfig.line = __assign(__assign({}, defaultLine), config.line);
    }
    if (config.details) {
        mergedConfig.details = __assign(__assign({}, defaultDetails), config.details);
    }
    return mergedConfig;
}
exports.mergeWithDefaultAnnotationLine = mergeWithDefaultAnnotationLine;
function mergeWithDefaultAnnotationRect(config) {
    if (!config) {
        return exports.DEFAULT_ANNOTATION_RECT_STYLE;
    }
    return __assign(__assign({}, exports.DEFAULT_ANNOTATION_RECT_STYLE), config);
}
exports.mergeWithDefaultAnnotationRect = mergeWithDefaultAnnotationRect;
/**
 * Merge theme or themes with a base theme
 *
 * priority is based on spatial order
 *
 * @param theme - primary partial theme
 * @param defaultTheme - base theme
 * @param axillaryThemes - additional themes to be merged
 */
function mergeWithDefaultTheme(theme, defaultTheme, axillaryThemes) {
    if (defaultTheme === void 0) { defaultTheme = light_theme_1.LIGHT_THEME; }
    if (axillaryThemes === void 0) { axillaryThemes = []; }
    return commons_1.mergePartial(defaultTheme, theme, { mergeOptionalPartialValues: true }, axillaryThemes);
}
exports.mergeWithDefaultTheme = mergeWithDefaultTheme;
//# sourceMappingURL=theme.js.map