"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var fast_deep_equal_1 = require("../../../../utils/fast_deep_equal");
var RectAnnotation = /** @class */ (function (_super) {
    __extends(RectAnnotation, _super);
    function RectAnnotation() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderAnnotationRect = function (_a, index) {
            var rect = _a.rect;
            var x = rect.x, y = rect.y, width = rect.width, height = rect.height;
            var rectProps = __assign(__assign({}, _this.props.rectStyle), { x: x,
                y: y,
                width: width,
                height: height });
            return react_1.default.createElement(react_konva_1.Rect, __assign({}, rectProps, { key: "rect-annotation-" + index }));
        };
        return _this;
    }
    RectAnnotation.prototype.shouldComponentUpdate = function (nextProps) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps);
    };
    RectAnnotation.prototype.render = function () {
        var rects = this.props.rects;
        return react_1.default.createElement(react_konva_1.Group, null, rects.map(this.renderAnnotationRect));
    };
    return RectAnnotation;
}(react_1.default.Component));
exports.RectAnnotation = RectAnnotation;
//# sourceMappingURL=rect_annotation.js.map