/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer.tableviewer;

import com.ca.commons.cbutil.CBIntText;
import com.ca.directory.jxplorer.editor.editablebinary;
import com.ca.directory.jxplorer.editor.editablestring;
import java.util.logging.Logger;

public class AttributeValue
implements editablebinary,
editablestring {
    public Object value;
    Object backup;
    boolean changed;
    boolean binary;
    String id;
    String[] options = null;
    private static final Logger log = Logger.getLogger(AttributeValue.class.getName());
    boolean naming;

    public AttributeValue(String ID2, Object v) {
        this.id = ID2;
        this.value = v;
        this.backup = v;
        this.changed = false;
        this.naming = false;
        this.testBinary();
    }

    public void setNamingStatus(boolean state) {
        this.naming = state;
    }

    public boolean isNaming() {
        return this.naming;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public void setOptions(String[] ops) {
        this.options = ops;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void update(Object data) {
        this.value = data;
        this.testBinary();
        if (!this.binary) {
            this.value = this.getStringValue();
        }
        this.changed = this.value != this.backup;
    }

    public void setValue(byte[] b) {
        this.update(b);
    }

    public void setStringValue(String b) {
        this.update(b);
    }

    public byte[] getValue() {
        if (this.binary) {
            if (this.value instanceof String) {
                log.warning("warning - Attribute Value " + this.value + " mis represented as byte array data");
                return null;
            }
            return (byte[])this.value;
        }
        return null;
    }

    public String getStringValue() {
        if (!this.binary) {
            String val = (String)this.value;
            if (this.naming) {
                int len = val.length();
                if ((val = val.trim()).length() == 0 && len > 0) {
                    val = " ";
                }
            }
            return val;
        }
        return null;
    }

    public void reset() {
        this.value = this.backup;
        this.changed = false;
        this.testBinary();
    }

    public void setBinary(boolean bin) {
        this.binary = bin;
        if (bin && this.value instanceof String) {
            this.value = null;
        }
    }

    public boolean testBinary() {
        if (this.binary) {
            return true;
        }
        this.binary = this.value == null ? false : !(this.value instanceof String);
        return this.binary;
    }

    public boolean isEmpty() {
        if (this.value == null) {
            return true;
        }
        if (this.binary) {
            return this.value instanceof byte[] && ((byte[])this.value).length == 0;
        }
        return this.value.toString().length() == 0;
    }

    public String toString() {
        if (this.value == null) {
            return " ";
        }
        if (this.value.toString().length() == 0) {
            return " ";
        }
        if (this.binary) {
            return CBIntText.get("(non string data)");
        }
        return this.value.toString();
    }

    public String getID() {
        return this.id;
    }

    public boolean changed() {
        return this.changed;
    }

    public Object value() {
        return this.value;
    }

    public Object backup() {
        return this.backup;
    }

    public boolean isBinary() {
        return this.binary;
    }
}

