/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBAction;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.MainMenu;
import com.ca.directory.jxplorer.search.SearchGUI;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class AdvancedOptions
extends JDialog {
    private CBButton btnApply;
    private CBButton btnReset;
    private CBButton btnCancel;
    private CBButton btnHelp;
    private JTextField ldapLimit;
    private JTextField ldapTimeout;
    private JComboBox urlCombo;
    private JComboBox logLevelCombo;
    private JComboBox logMethodCombo;
    private JComboBox cachePwdCombo;
    private CBPanel display;
    private JTabbedPane tabbedPane;
    private JRadioButton[] lookAndFeel;
    private String[] lookAndFeelVal;
    private final String[] logLevelVal = new String[]{CBIntText.get("Severe"), CBIntText.get("Warning"), CBIntText.get("Info"), CBIntText.get("Fine"), CBIntText.get("Finest"), CBIntText.get("All + BER Trace")};
    private final String[] logMethodVal = new String[]{CBIntText.get("None"), CBIntText.get("Console"), CBIntText.get("File"), CBIntText.get("Console & File")};
    private MainMenu mainMenu;
    private final JXplorer jx;
    private String dirImage;
    private static final int WINDOWS = 0;
    private static final int JAVA = 1;
    protected static final int MOTIF = 2;
    protected static final int MAC = 3;
    private static Logger log = Logger.getLogger(AdvancedOptions.class.getName());
    public static final String WINDOWS_LF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String JAVA_LF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String MOTIF_LF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String MAC_LF = "com.sun.java.swing.plaf.mac.MacLookAndFeel";

    public AdvancedOptions(JXplorer jxplorer, MainMenu mainMenu) {
        super(jxplorer);
        this.setModal(true);
        this.mainMenu = mainMenu;
        this.jx = jxplorer;
        this.dirImage = JXplorer.getProperty("dir.images");
        this.setTitle(CBIntText.get("JXplorer Advanced Options"));
        this.display = new CBPanel();
        this.btnApply = new CBButton(CBIntText.get("Apply"), CBIntText.get("Click here to apply the changes"));
        this.btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptions.this.apply();
            }
        });
        this.btnReset = new CBButton(CBIntText.get("Reset"), CBIntText.get("Click here to reset the options"));
        this.btnReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptions.this.reset();
            }
        });
        this.btnCancel = new CBButton(CBIntText.get("Cancel"), CBIntText.get("Click here to exit Advanced Options"));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptions.this.quit();
            }
        });
        this.btnHelp = new CBButton(CBIntText.get("Help"), CBIntText.get("Click here for help"));
        CBHelpSystem.useDefaultHelp(this.btnHelp, "config.advanced");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.display.getActionMap().put("enter", new MyAction(10));
        this.display.getActionMap().put("escape", new MyAction(27));
        this.tabbedPane = new JTabbedPane();
        this.lookAndFeelTab();
        this.ldapLevels();
        this.logLevel();
        this.logMethod();
        this.urlTab();
        this.pwdTab();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.btnApply);
        buttonPanel.add(this.btnReset);
        buttonPanel.add(this.btnCancel);
        buttonPanel.add(this.btnHelp);
        this.display.addln(this.tabbedPane);
        this.display.addln(buttonPanel);
        this.setSize(300, 280);
        this.getContentPane().add(this.display);
    }

    private void lookAndFeelTab() {
        this.lookAndFeel = new JRadioButton[]{new JRadioButton(CBIntText.get("Windows Look and Feel")), new JRadioButton(CBIntText.get("Java Look and Feel")), new JRadioButton(CBIntText.get("Motif Look and Feel")), new JRadioButton(CBIntText.get("Mac Look and Feel"))};
        String[] toolTip = new String[]{CBIntText.get("Sets the look and feel to: Windows"), CBIntText.get("Sets the look and feel to: Java"), CBIntText.get("Sets the look and feel to: Motif"), CBIntText.get("Sets the look and feel to: Apple Mac/OSX")};
        ButtonGroup lookAndFeelButtonGroup = new ButtonGroup();
        CBPanel lookAndFeelPanel = new CBPanel();
        lookAndFeelPanel.addln(new JLabel(CBIntText.get("Select a New Look & Feel: ")));
        lookAndFeelPanel.addln(new JLabel(" "));
        if (JXplorer.isWindows()) {
            this.addLookAndFeelOption(lookAndFeelButtonGroup, 0, lookAndFeelPanel, toolTip);
        } else {
            this.lookAndFeel[0].setSelected(false);
        }
        this.addLookAndFeelOption(lookAndFeelButtonGroup, 1, lookAndFeelPanel, toolTip);
        this.addLookAndFeelOption(lookAndFeelButtonGroup, 2, lookAndFeelPanel, toolTip);
        if (JXplorer.isMac()) {
            this.addLookAndFeelOption(lookAndFeelButtonGroup, 3, lookAndFeelPanel, toolTip);
        } else {
            this.lookAndFeel[3].setSelected(false);
        }
        this.getLookAndFeel();
        this.tabbedPane.addTab(CBIntText.get("Look & Feel"), new ImageIcon(this.dirImage + "look_feel.gif"), lookAndFeelPanel, CBIntText.get("Change the 'look and feel' of JXplorer, that is, adopt a similar appearance to another application."));
    }

    private void addLookAndFeelOption(ButtonGroup lookAndFeelButtonGroup, int i, CBPanel lookAndFeelPanel, String[] toolTip) {
        lookAndFeelButtonGroup.add(this.lookAndFeel[i]);
        lookAndFeelPanel.addln(this.lookAndFeel[i]);
        this.lookAndFeel[i].setToolTipText(toolTip[i]);
    }

    private void getLookAndFeel() {
        this.lookAndFeelVal = new String[]{WINDOWS_LF, JAVA_LF, MOTIF_LF, MAC_LF};
        for (int i = 0; i < 4; ++i) {
            if (!String.valueOf(this.lookAndFeelVal[i]).equalsIgnoreCase(JXplorer.getProperty("gui.lookandfeel"))) continue;
            this.lookAndFeel[i].setSelected(true);
        }
    }

    private void logMethod() {
        CBPanel logMethodPanel = new CBPanel();
        logMethodPanel.addln(new JLabel(CBIntText.get("Select a New Log Method: ")));
        logMethodPanel.addln(new JLabel(" "));
        this.logMethodCombo = new JComboBox<String>(this.logMethodVal);
        this.logMethodCombo.setToolTipText(CBIntText.get("Set the log method in JXplorer."));
        logMethodPanel.addln(this.logMethodCombo);
        logMethodPanel.addln(new JLabel(" "));
        this.getLogMethod();
        this.tabbedPane.addTab(CBIntText.get("Log Method"), new ImageIcon(this.dirImage + "log_method.gif"), logMethodPanel, CBIntText.get("Set the method of logging you want, for example, to a file."));
    }

    private void getLogMethod() {
        String logHandlers = JXplorer.getProperty("handlers");
        if (logHandlers.indexOf("ConsoleHandler") > 0 && logHandlers.indexOf("FileHandler") > 0) {
            this.logMethodCombo.setSelectedItem(this.logMethodVal[3]);
        } else if (logHandlers.indexOf("FileHandler") > 0) {
            this.logMethodCombo.setSelectedItem(this.logMethodVal[2]);
        } else if (logHandlers.indexOf("ConsoleHandler") > 0) {
            this.logMethodCombo.setSelectedItem(this.logMethodVal[1]);
        } else {
            this.logMethodCombo.setSelectedItem(this.logMethodVal[0]);
        }
    }

    private void logLevel() {
        CBPanel logLevelPanel = new CBPanel();
        logLevelPanel.addln(new JLabel(CBIntText.get("Select a New Log Level: ")));
        logLevelPanel.addln(new JLabel(" "));
        this.logLevelCombo = new JComboBox<String>(this.logLevelVal);
        this.logLevelCombo.setToolTipText(CBIntText.get("Set the logging level in JXplorer."));
        logLevelPanel.addln(this.logLevelCombo);
        logLevelPanel.addln(new JLabel(" "));
        this.getLogLevel();
        this.tabbedPane.addTab(CBIntText.get("Log Level"), new ImageIcon(this.dirImage + "log_level.gif"), logLevelPanel, CBIntText.get("Set the level of logging you want, for example, errors only."));
    }

    private void getLogLevel() {
        Level logLevel;
        try {
            logLevel = Level.parse(JXplorer.getProperty(".level"));
        }
        catch (Exception e) {
            logLevel = Level.WARNING;
        }
        if (logLevel.equals(Level.SEVERE)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[0]);
        } else if (logLevel.equals(Level.WARNING)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[1]);
        } else if (logLevel.equals(Level.INFO)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[2]);
        } else if (logLevel.equals(Level.FINE)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[3]);
        } else if (logLevel.equals(Level.FINEST)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[4]);
        } else if (logLevel.equals(Level.ALL)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[5]);
        } else {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[1]);
        }
    }

    private void ldapLevels() {
        this.ldapLimit = new JTextField();
        this.ldapTimeout = new JTextField();
        this.getLdapLevels();
        CBPanel ldapLevelsPanel = new CBPanel();
        ldapLevelsPanel.addln(new JLabel(CBIntText.get("Set LDAP Options:           ")));
        ldapLevelsPanel.addln(new JLabel(" "));
        ldapLevelsPanel.add(new JLabel(CBIntText.get("LDAP Limit: ")));
        ldapLevelsPanel.add(this.ldapLimit);
        ldapLevelsPanel.newLine();
        ldapLevelsPanel.addln(new JLabel(" "));
        ldapLevelsPanel.add(new JLabel(CBIntText.get("LDAP Timeout: ")));
        ldapLevelsPanel.add(this.ldapTimeout);
        this.tabbedPane.addTab(CBIntText.get("Search Limits"), new ImageIcon(this.dirImage + "find.gif"), ldapLevelsPanel, CBIntText.get("Set the search levels, that is, the number of entries returned from a search and the timeout."));
    }

    private void getLdapLevels() {
        String limit = JXplorer.getProperty("option.ldap.limit");
        String timeout = JXplorer.getProperty("option.ldap.timeout");
        this.ldapLimit.setText(limit);
        this.ldapLimit.setToolTipText(CBIntText.get("Enter the new limit level."));
        this.ldapTimeout.setText(timeout);
        this.ldapTimeout.setToolTipText(CBIntText.get("Enter the new timeout level."));
    }

    private void urlTab() {
        String[] url = new String[]{CBIntText.get("JXplorer"), CBIntText.get("Launch")};
        CBPanel urlPanel = new CBPanel();
        this.urlCombo = new JComboBox<String>(url);
        this.getURLHandling();
        urlPanel.addln(new JLabel(CBIntText.get("Select URL handling: ")));
        urlPanel.addln(new JLabel(" "));
        urlPanel.addln(this.urlCombo);
        urlPanel.addln(new JLabel(" "));
        urlPanel.addln(new JLabel(CBIntText.get("Note: Launch is for Windows only.")));
        this.tabbedPane.addTab(CBIntText.get("URL"), new ImageIcon(this.dirImage + "url.gif"), urlPanel, CBIntText.get("Select how you would like the URLs handled in JXplorer."));
    }

    private void getURLHandling() {
        String urlHandling = JXplorer.getProperty("option.url.handling");
        int index = 0;
        if (urlHandling != null && urlHandling.equalsIgnoreCase("Launch")) {
            index = 1;
        }
        this.urlCombo.setSelectedIndex(index);
    }

    private void pwdTab() {
        String[] cache = new String[]{CBIntText.get("Yes"), CBIntText.get("No")};
        CBPanel urlPanel = new CBPanel();
        this.cachePwdCombo = new JComboBox<String>(cache);
        this.getPasswordCachingOption();
        urlPanel.addln(new JLabel(CBIntText.get("Cache passwords: ")));
        urlPanel.addln(new JLabel(" "));
        urlPanel.addln(this.cachePwdCombo);
        urlPanel.addln(new JLabel(" "));
        urlPanel.addln(new JLabel(CBIntText.get(" ")));
        this.tabbedPane.addTab(CBIntText.get("Cache Passwords"), new ImageIcon(this.dirImage + "cachePwds.gif"), urlPanel, CBIntText.get("Select Yes if you want passwords cached in JXplorer."));
    }

    private void getPasswordCachingOption() {
        String pwdCaching = JXplorer.getProperty("jxplorer.cache.passwords");
        int index = 0;
        if (pwdCaching != null && pwdCaching.equalsIgnoreCase("false")) {
            index = 1;
        }
        this.cachePwdCombo.setSelectedIndex(index);
    }

    private void apply() {
        this.checkLookAndFeel();
        this.checkLogMethod();
        this.checkLogLevel();
        this.checkLdapLevels();
        this.checkUrlHandling();
        this.checkCachePwds();
        this.quit();
    }

    private void checkLookAndFeel() {
        AbstractButton rb = null;
        String currentLF = JXplorer.getProperty("gui.lookandfeel");
        try {
            if (this.lookAndFeel[0].isSelected()) {
                if (currentLF.equalsIgnoreCase(WINDOWS_LF)) {
                    return;
                }
                rb = this.setNewLookAndFeel(WINDOWS_LF, 0);
            } else if (this.lookAndFeel[1].isSelected()) {
                if (currentLF.equalsIgnoreCase(JAVA_LF)) {
                    return;
                }
                rb = this.setNewLookAndFeel(JAVA_LF, 1);
            } else if (this.lookAndFeel[2].isSelected()) {
                if (currentLF.equalsIgnoreCase(MOTIF_LF)) {
                    return;
                }
                rb = this.setNewLookAndFeel(MOTIF_LF, 2);
            } else if (this.lookAndFeel[3].isSelected()) {
                if (currentLF.equalsIgnoreCase(MAC_LF)) {
                    return;
                }
                rb = this.setNewLookAndFeel(MAC_LF, 3);
            }
        }
        catch (UnsupportedLookAndFeelException exc) {
            rb.setEnabled(false);
            log.warning("Unsupported LookAndFeel: " + rb.getText());
        }
        catch (Exception exc) {
            rb.setEnabled(false);
            exc.printStackTrace();
            log.warning("Could not load LookAndFeel: " + rb.getText());
            exc.printStackTrace();
        }
        this.getOwner().setCursor(Cursor.getPredefinedCursor(3));
        this.updateLookAndFeel();
        if (this.mainMenu.getConnection != null) {
            SwingUtilities.updateComponentTreeUI(this.mainMenu.getConnection);
        }
        this.getOwner().setCursor(Cursor.getPredefinedCursor(0));
        this.jx.getAttributeDisplay().refreshEditors();
    }

    private JRadioButton setNewLookAndFeel(String lf, int pos) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        JRadioButton rb = this.lookAndFeel[pos];
        UIManager.setLookAndFeel(lf);
        JXplorer.setProperty("gui.lookandfeel", lf);
        return rb;
    }

    private void updateLookAndFeel() {
        if (!(this.getOwner() instanceof JXplorer)) {
            SwingUtilities.updateComponentTreeUI(this.getOwner());
            return;
        }
        JXplorer jx = (JXplorer)this.getOwner();
        SwingUtilities.updateComponentTreeUI(jx);
        SwingUtilities.updateComponentTreeUI(this);
        SmartTree explore = jx.getTree();
        SmartTree search = jx.getSearchTree();
        SmartTree schema = jx.getSchemaTree();
        SwingUtilities.updateComponentTreeUI(explore);
        SwingUtilities.updateComponentTreeUI(search);
        SwingUtilities.updateComponentTreeUI(schema);
        SwingUtilities.updateComponentTreeUI(explore.getPopupTool());
        SwingUtilities.updateComponentTreeUI(search.getPopupTool());
        SwingUtilities.updateComponentTreeUI(schema.getPopupTool());
        SearchGUI sExplore = explore.getSearchGUI();
        SearchGUI sSearch = search.getSearchGUI();
        SearchGUI sSchema = schema.getSearchGUI();
        if (sExplore != null) {
            SwingUtilities.updateComponentTreeUI(sExplore);
        }
        if (sSearch != null) {
            SwingUtilities.updateComponentTreeUI(sSearch);
        }
        if (sSchema != null) {
            SwingUtilities.updateComponentTreeUI(sSchema);
        }
    }

    private void checkLogMethod() {
        try {
            int logMethod = this.logMethodCombo.getSelectedIndex();
            String original = JXplorer.getProperty("handlers");
            switch (logMethod) {
                case 0: {
                    JXplorer.setProperty("handlers", "");
                    break;
                }
                case 1: {
                    JXplorer.setProperty("handlers", "java.util.logging.ConsoleHandler");
                    break;
                }
                case 2: {
                    JXplorer.setProperty("handlers", "java.util.logging.FileHandler");
                    break;
                }
                case 3: {
                    JXplorer.setProperty("handlers", "java.util.logging.ConsoleHandler,java.util.logging.FileHandler");
                    break;
                }
                default: {
                    JXplorer.setProperty("handlers", "java.util.logging.ConsoleHandler,java.util.logging.FileHandler");
                }
            }
            if (!original.equals(JXplorer.getProperty("handlers"))) {
                JXplorer.writePropertyFile();
                JXplorer.setupLogger();
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void checkLogLevel() {
        String original = JXplorer.getProperty(".level");
        switch (this.logLevelCombo.getSelectedIndex()) {
            case 0: {
                JXplorer.setProperty(".level", "SEVERE");
                JXplorer.setProperty("com.ca.level", "SEVERE");
                break;
            }
            case 1: {
                JXplorer.setProperty(".level", "WARNING");
                JXplorer.setProperty("com.ca.level", "WARNING");
                break;
            }
            case 2: {
                JXplorer.setProperty(".level", "INFO");
                JXplorer.setProperty("com.ca.level", "INFO");
                break;
            }
            case 3: {
                JXplorer.setProperty(".level", "FINE");
                JXplorer.setProperty("com.ca.level", "FINE");
                break;
            }
            case 4: {
                JXplorer.setProperty(".level", "FINEST");
                JXplorer.setProperty("com.ca.level", "FINEST");
                break;
            }
            case 5: {
                JXplorer.setProperty(".level", "ALL");
                JXplorer.setProperty("com.ca.level", "ALL");
                break;
            }
            default: {
                JXplorer.setProperty(".level", "WARNING");
                JXplorer.setProperty("com.ca.level", "WARNING");
            }
        }
        if (!original.equals(JXplorer.getProperty(".handlers"))) {
            JXplorer.writePropertyFile();
            JXplorer.setupLogger();
        }
        this.jx.checkSpecialLoggingActions();
    }

    private void checkLdapLevels() {
        String limit = this.ldapLimit.getText();
        String timeout = this.ldapTimeout.getText();
        try {
            Integer.valueOf(limit);
            Integer.valueOf(timeout);
        }
        catch (NumberFormatException e) {
            CBUtility.error("Both Ldap Limit & Ldap timeout must be of Integer type.\n" + e);
            this.getLdapLevels();
        }
        JXplorer.setProperty("option.ldap.limit", limit);
        JXplorer.setProperty("option.ldap.timeout", timeout);
        this.jx.searchBroker.setTimeout(Integer.parseInt(timeout));
        this.jx.searchBroker.setLimit(Integer.parseInt(limit));
    }

    private void checkUrlHandling() {
        int index = this.urlCombo.getSelectedIndex();
        if (index == 1) {
            JXplorer.setProperty("option.url.handling", "Launch");
        } else {
            JXplorer.setProperty("option.url.handling", "JXplorer");
        }
    }

    private void checkCachePwds() {
        int index = this.cachePwdCombo.getSelectedIndex();
        if (index == 1) {
            JXplorer.setProperty("jxplorer.cache.passwords", "false");
        } else {
            JXplorer.setProperty("jxplorer.cache.passwords", "true");
        }
    }

    private void reset() {
        this.getLookAndFeel();
        this.getLogLevel();
        this.getLogMethod();
        this.getLdapLevels();
        this.getURLHandling();
        this.getPasswordCachingOption();
    }

    private void quit() {
        this.setVisible(false);
        this.dispose();
    }

    private class MyAction
    extends CBAction {
        public MyAction(int key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.getKey() == 27) {
                AdvancedOptions.this.quit();
            } else if (this.getKey() == 10) {
                AdvancedOptions.this.apply();
            }
        }
    }
}

