/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.util;

import com.ca.commons.security.asn1.ASN1OID;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.DERCoder;
import com.ca.commons.security.cert.extensions.AuthorityKeyIdentifier;
import com.ca.commons.security.cert.extensions.BasicConstraints;
import com.ca.commons.security.cert.extensions.SubjectKeyIdentifier;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;

public class CertUtil {
    public static X509Certificate loadX509Certificate(String fileName) {
        return CertUtil.loadX509Certificate(new File(fileName));
    }

    public static X509Certificate loadX509Certificate(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            inputStream.close();
            return cert;
        }
        catch (Exception anyException) {
            anyException.printStackTrace();
            return null;
        }
    }

    public static X509Certificate loadX509Certificate(byte[] certdata) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(certdata);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            inputStream.close();
            return cert;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveCertToDisk(byte[] certBytes, String outputDir) throws Exception {
        X509Certificate cert = CertUtil.loadX509Certificate(certBytes);
        FileOutputStream fos = null;
        String fileName = outputDir + "/" + cert.getSubjectDN().getName() + "_" + new Date().getTime() + ".der";
        try {
            fos = new FileOutputStream(fileName);
        }
        catch (Exception ex) {
            StringBuffer stringBuffer = new StringBuffer().append("Could not open ").append(fileName).append(" for saving cert, now use ");
            fileName = new Date().getTime() + ".der";
            System.out.println(stringBuffer.append(fileName).toString());
            fos = new FileOutputStream(fileName);
        }
        fos.write(certBytes);
        fos.close();
    }

    public static AuthorityKeyIdentifier getAuthorityKeyIdentifier(X509Certificate theCert) {
        AuthorityKeyIdentifier v3e = null;
        byte[] aki = theCert.getExtensionValue(ASN1OID.authorityKeyIdentifier);
        ASN1Object rext = CertUtil.decodeExtension(aki);
        if (rext != null) {
            v3e = new AuthorityKeyIdentifier();
            try {
                v3e.init(rext);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return v3e;
    }

    public static byte[] getIssuerKeyId(X509Certificate theCert) {
        AuthorityKeyIdentifier v3e = CertUtil.getAuthorityKeyIdentifier(theCert);
        if (v3e == null) {
            return null;
        }
        byte[] keyId = v3e.getKeyId();
        return keyId;
    }

    public static BigInteger getIssuerSerialNumber(X509Certificate theCert) {
        AuthorityKeyIdentifier v3e = CertUtil.getAuthorityKeyIdentifier(theCert);
        if (v3e == null) {
            return null;
        }
        BigInteger issuerSerialNumber = v3e.getSerialNumber();
        return issuerSerialNumber;
    }

    public static ASN1Object decodeExtension(byte[] extvalue) {
        ASN1Object rext = null;
        if (extvalue != null) {
            try {
                DERCoder derCoder = new DERCoder();
                ASN1Object ext = derCoder.decode(extvalue);
                if (ext.isASN1Type(ASN1Type.OCTET_STRING)) {
                    rext = derCoder.decode((byte[])ext.getValue());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return rext;
    }

    public static SubjectKeyIdentifier getSubjectKeyIdentifier(X509Certificate theCert) {
        SubjectKeyIdentifier v3e = null;
        byte[] ski = theCert.getExtensionValue(ASN1OID.subjectKeyIdentifier);
        ASN1Object rext = CertUtil.decodeExtension(ski);
        if (rext != null) {
            v3e = new SubjectKeyIdentifier();
            try {
                v3e.init(rext);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return v3e;
    }

    public static byte[] getSubjectKeyId(X509Certificate theCert) {
        SubjectKeyIdentifier v3e = CertUtil.getSubjectKeyIdentifier(theCert);
        if (v3e == null) {
            return null;
        }
        byte[] keyId = v3e.getKeyId();
        return keyId;
    }

    public static int getPathLenConstraint(X509Certificate cert) {
        byte[] bs = cert.getExtensionValue(ASN1OID.basicConstraints);
        if (bs != null) {
            try {
                DERCoder derCoder = new DERCoder();
                ASN1Object ext = derCoder.decode(bs);
                ext = derCoder.decode((byte[])ext.getValue());
                BasicConstraints bsASN = new BasicConstraints();
                bsASN.init(ext);
                return bsASN.pathLenConstraint;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return -1;
    }
}

