/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class DownloadSelectedIncompleteMembersAction
extends AbstractRelationAction {
    private transient Collection<IPrimitive> incompleteMembers;

    public DownloadSelectedIncompleteMembersAction() {
        this.putValue("ShortDescription", I18n.tr("Download incomplete members of selected relations", new Object[0]));
        new ImageProvider("dialogs/relation", "downloadincompleteselected").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Download incomplete members", new Object[0]));
    }

    public static Set<IPrimitive> buildSetOfIncompleteMembers(Collection<IRelation<?>> rels) {
        HashSet<IPrimitive> ret = new HashSet<IPrimitive>();
        for (IRelation<?> r : rels) {
            ret.addAll(SubclassFilteredCollection.filter(r.getIncompleteMembers(), osm -> !osm.isNew()));
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || this.relations.isEmpty() || !MainApplication.isDisplayingMapView()) {
            return;
        }
        MainApplication.worker.submit(new DownloadRelationMemberTask(Utils.filteredCollection(this.relations, Relation.class), Utils.filteredCollection(this.incompleteMembers, OsmPrimitive.class), MainApplication.getLayerManager().getEditLayer()));
    }

    @Override
    public void setPrimitives(Collection<? extends IPrimitive> primitives) {
        this.relations = SubclassFilteredCollection.filter(DownloadSelectedIncompleteMembersAction.getRelations(primitives), IRelation::hasIncompleteMembers);
        this.incompleteMembers = DownloadSelectedIncompleteMembersAction.buildSetOfIncompleteMembers(this.relations);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.incompleteMembers.isEmpty() && this.canDownload());
    }
}

