/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jd.core.v1.model.classfile.ConstantPool;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.attribute.AttributeLineNumberTable;
import org.jd.core.v1.model.classfile.attribute.CodeException;
import org.jd.core.v1.model.classfile.attribute.LineNumber;
import org.jd.core.v1.model.classfile.constant.ConstantMemberRef;
import org.jd.core.v1.model.classfile.constant.ConstantNameAndType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ByteCodeParser;
import org.jd.core.v1.util.DefaultList;

public class ControlFlowGraphMaker {
    protected static final BasicBlock MARK = BasicBlock.END;
    protected static final CodeExceptionComparator CODE_EXCEPTION_COMPARATOR = new CodeExceptionComparator();

    public static ControlFlowGraph make(Method method) {
        int[] offsets;
        int[] values;
        int i;
        AttributeCode attributeCode = (AttributeCode)method.getAttribute("Code");
        if (attributeCode == null) {
            return null;
        }
        ConstantPool constants = method.getConstants();
        byte[] code = attributeCode.getCode();
        int length = code.length;
        BasicBlock[] map = new BasicBlock[length];
        char[] types = new char[length];
        int[] nextOffsets = new int[length];
        int[] branchOffsets = new int[length];
        int[][] switchValues = new int[length][];
        int[][] switchOffsets = new int[length][];
        map[0] = MARK;
        int lastOffset = 0;
        int lastStatementOffset = -1;
        block39: for (int offset = 0; offset < length; ++offset) {
            nextOffsets[lastOffset] = offset;
            lastOffset = offset;
            int opcode = code[offset] & 0xFF;
            switch (opcode) {
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 188: {
                    ++offset;
                    continue block39;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    lastStatementOffset = ++offset;
                    continue block39;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 194: 
                case 195: {
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 169: {
                    types[++offset] = 82;
                    if (offset + 1 < length) {
                        map[offset + 1] = MARK;
                    }
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 179: 
                case 181: {
                    lastStatementOffset = offset += 2;
                    continue block39;
                }
                case 182: 
                case 183: 
                case 184: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    if (descriptor.charAt(descriptor.length() - 1) != 'V') continue block39;
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 185: 
                case 186: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    offset += 2;
                    if (descriptor.charAt(descriptor.length() - 1) != 'V') continue block39;
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 132: {
                    if (lastStatementOffset + 3 != (offset += 2) || ControlFlowGraphMaker.checkILOADForIINC(code, offset, code[offset - 1] & 0xFF)) continue block39;
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 17: 
                case 19: 
                case 20: 
                case 178: 
                case 180: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    offset += 2;
                    continue block39;
                }
                case 167: {
                    int type;
                    int n = type = lastStatementOffset + 1 == offset ? 103 : 71;
                    if (lastStatementOffset != -1) {
                        map[lastStatementOffset + 1] = MARK;
                    }
                    types[offset] = type;
                    int branchOffset = offset++ + (short)((code[offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    map[branchOffset] = MARK;
                    types[offset] = type;
                    branchOffsets[offset] = branchOffset;
                    if (offset + 1 < length) {
                        map[offset + 1] = MARK;
                    }
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 168: {
                    if (lastStatementOffset != -1) {
                        map[lastStatementOffset + 1] = MARK;
                    }
                    types[offset] = 106;
                    int branchOffset = offset++ + (short)((code[offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    map[branchOffset] = MARK;
                    types[offset] = 106;
                    branchOffsets[offset] = branchOffset;
                    if (offset + 1 < length) {
                        map[offset + 1] = MARK;
                    }
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    if (lastStatementOffset != -1) {
                        map[lastStatementOffset + 1] = MARK;
                    }
                    int branchOffset = offset++ + (short)((code[offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    map[branchOffset] = MARK;
                    types[offset] = 99;
                    branchOffsets[offset] = branchOffset;
                    if (offset + 1 < length) {
                        map[offset + 1] = MARK;
                    }
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 170: {
                    int branchOffset;
                    i = offset + 4 & 0xFFFC;
                    int defaultOffset = offset + ((code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF);
                    map[defaultOffset] = MARK;
                    int low = (code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF;
                    int high = (code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF;
                    values = new int[high - low + 2];
                    offsets = new int[high - low + 2];
                    offsets[0] = defaultOffset;
                    int len = high - low + 2;
                    for (int j = 1; j < len; ++j) {
                        values[j] = low + j - 1;
                        branchOffset = offsets[j] = offset + ((code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF);
                        map[branchOffset] = MARK;
                    }
                    offset = i - 1;
                    types[offset] = 115;
                    switchValues[offset] = values;
                    switchOffsets[offset] = offsets;
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 171: {
                    int branchOffset;
                    i = offset + 4 & 0xFFFC;
                    int defaultOffset = offset + ((code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF);
                    map[defaultOffset] = MARK;
                    int npairs = (code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF;
                    values = new int[npairs + 1];
                    offsets = new int[npairs + 1];
                    offsets[0] = defaultOffset;
                    for (int j = 1; j <= npairs; ++j) {
                        values[j] = (code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF;
                        branchOffset = offsets[j] = offset + ((code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF);
                        map[branchOffset] = MARK;
                    }
                    offset = i - 1;
                    types[offset] = 115;
                    switchValues[offset] = values;
                    switchOffsets[offset] = offsets;
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    types[offset] = 118;
                    if (offset + 1 < length) {
                        map[offset + 1] = MARK;
                    }
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 177: {
                    if (lastStatementOffset != -1) {
                        map[lastStatementOffset + 1] = MARK;
                    }
                    types[offset] = 114;
                    if (offset + 1 < length) {
                        map[offset + 1] = MARK;
                    }
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 191: {
                    types[offset] = 116;
                    if (offset + 1 < length) {
                        map[offset + 1] = MARK;
                    }
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 196: {
                    opcode = code[++offset] & 0xFF;
                    switch (opcode) {
                        case 132: {
                            if (lastStatementOffset + 6 != (offset += 4) || ControlFlowGraphMaker.checkILOADForIINC(code, offset, (code[offset - 3] & 0xFF) << 8 | code[offset - 2] & 0xFF)) continue block39;
                            lastStatementOffset = offset;
                            continue block39;
                        }
                        case 169: {
                            types[offset += 2] = 82;
                            if (offset + 1 < length) {
                                map[offset + 1] = MARK;
                            }
                            lastStatementOffset = offset;
                            continue block39;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: {
                            lastStatementOffset = offset + 2;
                        }
                    }
                    offset += 2;
                    continue block39;
                }
                case 197: {
                    offset += 3;
                    continue block39;
                }
                case 200: {
                    int type;
                    types[offset] = type = lastStatementOffset + 1 == offset ? 103 : 71;
                    int branchOffset = offset++ + ((code[offset] & 0xFF) << 24 | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    map[branchOffset] = MARK;
                    types[offset] = type;
                    branchOffsets[offset] = branchOffset;
                    if (offset + 1 < length) {
                        map[offset + 1] = MARK;
                    }
                    lastStatementOffset = offset;
                    continue block39;
                }
                case 201: {
                    if (lastStatementOffset != -1) {
                        map[lastStatementOffset + 1] = MARK;
                    }
                    types[offset] = 106;
                    int branchOffset = offset++ + ((code[offset] & 0xFF) << 24 | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    map[branchOffset] = MARK;
                    types[offset] = 106;
                    branchOffsets[offset] = branchOffset;
                    if (offset + 1 < length) {
                        map[offset + 1] = MARK;
                    }
                    lastStatementOffset = offset;
                }
            }
        }
        nextOffsets[lastOffset] = length;
        CodeException[] codeExceptions = attributeCode.getExceptionTable();
        if (codeExceptions != null) {
            for (CodeException codeException : codeExceptions) {
                map[codeException.getStartPc()] = MARK;
                map[codeException.getHandlerPc()] = MARK;
            }
        }
        ControlFlowGraph cfg = new ControlFlowGraph(method);
        AttributeLineNumberTable attributeLineNumberTable = (AttributeLineNumberTable)attributeCode.getAttribute("LineNumberTable");
        if (attributeLineNumberTable != null) {
            LineNumber[] lineNumberTable = attributeLineNumberTable.getLineNumberTable();
            int[] offsetToLineNumbers = new int[length];
            int offset = 0;
            int lineNumber = lineNumberTable[0].getLineNumber();
            int len = lineNumberTable.length;
            for (i = 1; i < len; ++i) {
                LineNumber lineNumberEntry = lineNumberTable[i];
                int toIndex = lineNumberEntry.getStartPc();
                while (offset < toIndex) {
                    offsetToLineNumbers[offset++] = lineNumber;
                }
                if (lineNumber > lineNumberEntry.getLineNumber()) {
                    map[offset] = MARK;
                }
                lineNumber = lineNumberEntry.getLineNumber();
            }
            while (offset < length) {
                offsetToLineNumbers[offset++] = lineNumber;
            }
            cfg.setOffsetToLineNumbers(offsetToLineNumbers);
        }
        lastOffset = 0;
        BasicBlock startBasicBlock = cfg.newBasicBlock(1, 0, 0);
        int offset = nextOffsets[0];
        while (offset < length) {
            if (map[offset] != null) {
                map[lastOffset] = cfg.newBasicBlock(lastOffset, offset);
                lastOffset = offset;
            }
            offset = nextOffsets[offset];
        }
        map[lastOffset] = cfg.newBasicBlock(lastOffset, length);
        DefaultList<BasicBlock> list = cfg.getBasicBlocks();
        DefaultList<BasicBlock> basicBlocks = new DefaultList<BasicBlock>(list.size());
        BasicBlock successor = (BasicBlock)list.get(1);
        startBasicBlock.setNext(successor);
        successor.getPredecessors().add(startBasicBlock);
        int basicBlockLength = list.size();
        block47: for (i = 1; i < basicBlockLength; ++i) {
            BasicBlock basicBlock = (BasicBlock)list.get(i);
            int lastInstructionOffset = basicBlock.getToOffset() - 1;
            switch (types[lastInstructionOffset]) {
                case 'g': {
                    basicBlock.setType(0x4000000);
                    successor = map[branchOffsets[lastInstructionOffset]];
                    basicBlock.setNext(successor);
                    successor.getPredecessors().add(basicBlock);
                    continue block47;
                }
                case 'G': {
                    basicBlock.setType(0x10000000);
                    successor = map[branchOffsets[lastInstructionOffset]];
                    basicBlock.setNext(successor);
                    successor.getPredecessors().add(basicBlock);
                    continue block47;
                }
                case 't': {
                    basicBlock.setType(8);
                    basicBlock.setNext(BasicBlock.END);
                    continue block47;
                }
                case 'r': {
                    basicBlock.setType(16);
                    basicBlock.setNext(BasicBlock.END);
                    continue block47;
                }
                case 'c': {
                    basicBlock.setType(32768);
                    successor = map[basicBlock.getToOffset()];
                    basicBlock.setNext(successor);
                    successor.getPredecessors().add(basicBlock);
                    successor = map[branchOffsets[lastInstructionOffset]];
                    basicBlock.setBranch(successor);
                    successor.getPredecessors().add(basicBlock);
                    continue block47;
                }
                case 's': {
                    basicBlock.setType(64);
                    values = switchValues[lastInstructionOffset];
                    offsets = switchOffsets[lastInstructionOffset];
                    DefaultList<BasicBlock.SwitchCase> switchCases = new DefaultList<BasicBlock.SwitchCase>(offsets.length);
                    int defaultOffset = offsets[0];
                    BasicBlock bb = map[defaultOffset];
                    switchCases.add(new BasicBlock.SwitchCase(bb));
                    bb.getPredecessors().add(basicBlock);
                    int len = offsets.length;
                    for (int j = 1; j < len; ++j) {
                        int offset2 = offsets[j];
                        if (offset2 == defaultOffset) continue;
                        bb = map[offset2];
                        switchCases.add(new BasicBlock.SwitchCase(values[j], bb));
                        bb.getPredecessors().add(basicBlock);
                    }
                    basicBlock.setSwitchCases(switchCases);
                    continue block47;
                }
                case 'j': {
                    basicBlock.setType(8192);
                    successor = map[basicBlock.getToOffset()];
                    basicBlock.setNext(successor);
                    successor.getPredecessors().add(basicBlock);
                    successor = map[branchOffsets[lastInstructionOffset]];
                    basicBlock.setBranch(successor);
                    successor.getPredecessors().add(basicBlock);
                    continue block47;
                }
                case 'R': {
                    basicBlock.setType(16384);
                    basicBlock.setNext(BasicBlock.END);
                    continue block47;
                }
                case 'v': {
                    basicBlock.setType(32);
                    basicBlock.setNext(BasicBlock.END);
                    continue block47;
                }
                default: {
                    basicBlock.setType(4);
                    successor = map[basicBlock.getToOffset()];
                    basicBlock.setNext(successor);
                    successor.getPredecessors().add(basicBlock);
                    basicBlocks.add(basicBlock);
                }
            }
        }
        if (codeExceptions != null) {
            HashMap<CodeException, BasicBlock> cache = new HashMap<CodeException, BasicBlock>();
            ConstantPool constantPool = method.getConstants();
            int[] handlePcToStartPc = branchOffsets;
            char[] handlePcMarks = types;
            Arrays.sort(codeExceptions, CODE_EXCEPTION_COMPARATOR);
            for (CodeException codeException : codeExceptions) {
                int handlerPc;
                int startPc = codeException.getStartPc();
                if (startPc == (handlerPc = codeException.getHandlerPc()) || handlePcMarks[handlerPc] == 'T' && startPc > map[handlePcToStartPc[handlerPc]].getFromOffset()) continue;
                int catchType = codeException.getCatchType();
                BasicBlock tcf = (BasicBlock)cache.get(codeException);
                if (tcf == null) {
                    int endPc = codeException.getEndPc();
                    BasicBlock start = map[startPc];
                    tcf = cfg.newBasicBlock(512, startPc, endPc);
                    tcf.setNext(start);
                    HashSet<BasicBlock> tcfPredecessors = tcf.getPredecessors();
                    HashSet<BasicBlock> startPredecessors = start.getPredecessors();
                    Iterator iterator = startPredecessors.iterator();
                    while (iterator.hasNext()) {
                        BasicBlock predecessor = (BasicBlock)iterator.next();
                        if (start.contains(predecessor)) continue;
                        predecessor.replace(start, tcf);
                        tcfPredecessors.add(predecessor);
                        iterator.remove();
                    }
                    startPredecessors.add(tcf);
                    map[startPc] = tcf;
                    cache.put(codeException, tcf);
                }
                String internalThrowableName = catchType == 0 ? null : constantPool.getConstantTypeName(catchType);
                BasicBlock handlerBB = map[handlerPc];
                tcf.addExceptionHandler(internalThrowableName, handlerBB);
                handlerBB.getPredecessors().add(tcf);
                handlePcToStartPc[handlerPc] = startPc;
                handlePcMarks[handlerPc] = 84;
            }
        }
        for (BasicBlock bb : basicBlocks) {
            HashSet<BasicBlock> predecessors;
            BasicBlock next = bb.getNext();
            if (bb.getType() != 4 || next.getPredecessors().size() != 1) continue;
            if (next.getType() == 0x4000000 && ByteCodeParser.evalStackDepth(constants, code, bb) > 0) {
                bb.setType(0x10000000);
                bb.setToOffset(next.getToOffset());
                bb.setNext(next.getNext());
                predecessors = next.getNext().getPredecessors();
                predecessors.remove(next);
                predecessors.add(bb);
                next.setType(0);
                continue;
            }
            if (next.getType() != 32768 || ByteCodeParser.evalStackDepth(constants, code, bb) <= 0) continue;
            bb.setType(32768);
            bb.setToOffset(next.getToOffset());
            bb.setNext(next.getNext());
            predecessors = next.getNext().getPredecessors();
            predecessors.remove(next);
            predecessors.add(bb);
            bb.setBranch(next.getBranch());
            predecessors = next.getBranch().getPredecessors();
            predecessors.remove(next);
            predecessors.add(bb);
            next.setType(0);
        }
        return cfg;
    }

    protected static boolean checkILOADForIINC(byte[] code, int offset, int index) {
        int nextOpcode;
        return ++offset < code.length && ((nextOpcode = code[offset] & 0xFF) == 21 ? index == (code[offset + 1] & 0xFF) : nextOpcode == 26 + index);
    }

    public static class CodeExceptionComparator
    implements Comparator<CodeException> {
        @Override
        public int compare(CodeException ce1, CodeException ce2) {
            int comp = ce1.getStartPc() - ce2.getStartPc();
            if (comp == 0) {
                comp = ce1.getEndPc() - ce2.getEndPc();
            }
            return comp;
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }
    }
}

