/*
 * Decompiled with CFR 0.152.
 */
package elements;

import elements.Brick;
import elements.BrickCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import values.BrickColor;
import values.Orientation;
import values.Settings;

public class Field {
    private Settings settings;
    private List<Brick> list = new ArrayList<Brick>();
    private List<Brick> listBackup = new ArrayList<Brick>();
    private Brick[][] bricks = new Brick[10][10];
    private Brick[][] bricksBackup = new Brick[10][10];
    private Orientation[][] orientBackup = new Orientation[10][10];
    private static Random generator = new Random(System.currentTimeMillis());
    private BrickCollection leftBricks;
    private BrickCollection rightBricks;
    private BrickCollection topBricks;
    private BrickCollection bottomBricks;
    private int[][] matrix1 = new int[10][10];
    private int[][] matrix2 = new int[10][10];

    public Field(Settings settings, BrickCollection brickCollection, BrickCollection brickCollection2, BrickCollection brickCollection3, BrickCollection brickCollection4) {
        this.settings = settings;
        this.fill(settings.getLevel() - 1);
        this.leftBricks = brickCollection;
        this.rightBricks = brickCollection2;
        this.topBricks = brickCollection3;
        this.bottomBricks = brickCollection4;
    }

    public void saveToStream(OutputStream outputStream) throws IOException {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                outputStream.write(this.bricks[i][j].getColor().getIndex());
                outputStream.write(this.bricks[i][j].getOrientation().ordinal());
            }
        }
    }

    public void loadFromStream(InputStream inputStream) throws IOException {
        this.list.clear();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                int n = inputStream.read();
                this.bricks[i][j] = n < 0 || n > 9 ? new Brick() : new Brick(new BrickColor(n));
                this.bricks[i][j].setOrientation(Orientation.values()[inputStream.read()]);
                this.list.add(this.bricks[i][j]);
            }
        }
    }

    public void save() {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.bricksBackup[i][j] = this.bricks[i][j];
                this.orientBackup[i][j] = this.bricks[i][j].getOrientation();
            }
        }
        this.listBackup.clear();
        this.listBackup.addAll(this.list);
    }

    public void restore() {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.bricks[i][j] = this.bricksBackup[i][j];
                this.bricks[i][j].setOrientation(this.orientBackup[i][j]);
            }
        }
        this.list.clear();
        this.list.addAll(this.listBackup);
    }

    private void fillPuzzle(int n) {
        int n2 = 0;
        for (int i = 0; i < 20; ++i) {
            for (int j = i; j >= 0; --j) {
                if (j >= 10 || i - j >= 10) continue;
                this.bricks[j][i - j] = new Brick(this.settings.getDifficulty());
                this.list.add(this.bricks[j][i - j]);
                if (n2++ != this.settings.getDifficulty() + n - 1) continue;
                return;
            }
        }
    }

    private void fillNormal(int n) {
        this.bricks[6][4] = new Brick(this.settings.getDifficulty());
        this.list.add(this.bricks[6][4]);
        this.bricks[6][5] = new Brick(this.settings.getDifficulty());
        this.list.add(this.bricks[6][5]);
        this.bricks[5][6] = new Brick(this.settings.getDifficulty());
        this.list.add(this.bricks[5][6]);
        this.bricks[4][6] = new Brick(this.settings.getDifficulty());
        this.list.add(this.bricks[4][6]);
        this.bricks[3][5] = new Brick(this.settings.getDifficulty());
        this.list.add(this.bricks[3][5]);
        if (this.settings.getDifficulty() > 5) {
            this.bricks[3][4] = new Brick(this.settings.getDifficulty());
            this.list.add(this.bricks[3][4]);
        }
        if (this.settings.getDifficulty() > 6) {
            this.bricks[4][3] = new Brick(this.settings.getDifficulty());
            this.list.add(this.bricks[4][3]);
        }
        if (this.settings.getDifficulty() > 7) {
            this.bricks[5][3] = new Brick(this.settings.getDifficulty());
            this.list.add(this.bricks[5][3]);
        }
        if (this.settings.getDifficulty() > 8) {
            this.bricks[5][4] = new Brick(this.settings.getDifficulty());
            this.list.add(this.bricks[5][4]);
        }
        if (this.settings.getDifficulty() > 9) {
            this.bricks[4][5] = new Brick(this.settings.getDifficulty());
            this.list.add(this.bricks[4][5]);
        }
        for (int i = 0; i < n && !this.isFull(); ++i) {
            int n2;
            int n3;
            while (this.bricks[n3 = generator.nextInt(10)][n2 = generator.nextInt(10)] != null) {
            }
            this.bricks[n3][n2] = new Brick(this.settings.getDifficulty());
            this.list.add(this.bricks[n3][n2]);
        }
    }

    private void fill(int n) {
        if (this.settings.getGameType().isPuzzle().booleanValue()) {
            this.fillPuzzle(n);
        } else {
            this.fillNormal(n);
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.bricks[i][j] != null) continue;
                this.bricks[i][j] = new Brick();
                this.list.add(this.bricks[i][j]);
            }
        }
    }

    public void reInit() {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.bricks[i][j] != null) {
                    this.bricks[i][j].getColor().reInit();
                    this.bricks[i][j].update();
                }
                if (this.bricksBackup[i][j] == null) continue;
                this.bricksBackup[i][j].getColor().reInit();
            }
        }
    }

    public Brick getBrick(int n, int n2) {
        return this.bricks[n][n2];
    }

    public Brick setBrick(int n, int n2, Brick brick) {
        Brick brick2 = this.bricks[n][n2];
        this.bricks[n][n2] = brick;
        this.list.remove(brick2);
        this.list.add(brick);
        return brick2;
    }

    public boolean contains(Brick brick) {
        return this.list.contains(brick);
    }

    public int check(int n, Orientation orientation) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (n < 0 || n >= 10) {
                            return -1;
                        }
                        if (orientation != Orientation.LEFT) break block5;
                        for (int i = 0; i < 10; ++i) {
                            if (this.bricks[i][n].hasSameColor(Brick.BLACK)) continue;
                            return i;
                        }
                        break block6;
                    }
                    if (orientation != Orientation.RIGHT) break block7;
                    for (int i = 9; i >= 0; --i) {
                        if (this.bricks[i][n].hasSameColor(Brick.BLACK)) continue;
                        return i;
                    }
                    break block6;
                }
                if (orientation != Orientation.TOP) break block8;
                for (int i = 0; i < 10; ++i) {
                    if (this.bricks[n][i].hasSameColor(Brick.BLACK)) continue;
                    return i;
                }
                break block6;
            }
            if (orientation != Orientation.BOTTOM) break block6;
            for (int i = 9; i >= 0; --i) {
                if (this.bricks[n][i].hasSameColor(Brick.BLACK)) continue;
                return i;
            }
        }
        return -1;
    }

    private void analizeSpecialColors(int n, int n2) {
        if (n != 0 && n2 != 0 && this.matrix1[n - 1][n2 - 1] >= 0) {
            this.setBrick(n - 1, n2 - 1, new Brick(new BrickColor(this.bricks[n - 1][n2 - 1].getColor(), this.settings.getDifficulty()), this.bricks[n - 1][n2 - 1].getOrientation()));
        }
        if (n != 0 && this.matrix1[n - 1][n2] >= 0) {
            this.setBrick(n - 1, n2, new Brick(new BrickColor(this.bricks[n - 1][n2].getColor(), this.settings.getDifficulty()), this.bricks[n - 1][n2].getOrientation()));
        }
        if (n != 0 && n2 != 9 && this.matrix1[n - 1][n2 + 1] >= 0) {
            this.setBrick(n - 1, n2 + 1, new Brick(new BrickColor(this.bricks[n - 1][n2 + 1].getColor(), this.settings.getDifficulty()), this.bricks[n - 1][n2 + 1].getOrientation()));
        }
        if (n2 != 0 && this.matrix1[n][n2 - 1] >= 0) {
            this.setBrick(n, n2 - 1, new Brick(new BrickColor(this.bricks[n][n2 - 1].getColor(), this.settings.getDifficulty()), this.bricks[n][n2 - 1].getOrientation()));
        }
        this.addBlack(n, n2);
        if (n2 != 9 && this.matrix1[n][n2 + 1] >= 0) {
            this.setBrick(n, n2 + 1, new Brick(new BrickColor(this.bricks[n][n2 + 1].getColor(), this.settings.getDifficulty()), this.bricks[n][n2 + 1].getOrientation()));
        }
        if (n != 9 && n2 != 0 && this.matrix1[n + 1][n2 - 1] >= 0) {
            this.setBrick(n + 1, n2 - 1, new Brick(new BrickColor(this.bricks[n + 1][n2 - 1].getColor(), this.settings.getDifficulty()), this.bricks[n + 1][n2 - 1].getOrientation()));
        }
        if (n != 9 && this.matrix1[n + 1][n2] >= 0) {
            this.setBrick(n + 1, n2, new Brick(new BrickColor(this.bricks[n + 1][n2].getColor(), this.settings.getDifficulty()), this.bricks[n + 1][n2].getOrientation()));
        }
        if (n != 9 && n2 != 9 && this.matrix1[n + 1][n2 + 1] >= 0) {
            this.setBrick(n + 1, n2 + 1, new Brick(new BrickColor(this.bricks[n + 1][n2 + 1].getColor(), this.settings.getDifficulty()), this.bricks[n + 1][n2 + 1].getOrientation()));
        }
    }

    private void analizeSpecialArrows(int n, int n2) {
        if (n != 0 && n2 != 0 && this.matrix1[n - 1][n2 - 1] >= 0) {
            this.bricks[n - 1][n2 - 1].rotate();
        }
        if (n != 0 && this.matrix1[n - 1][n2] >= 0) {
            this.bricks[n - 1][n2].rotate();
        }
        if (n != 0 && n2 != 9 && this.matrix1[n - 1][n2 + 1] >= 0) {
            this.bricks[n - 1][n2 + 1].rotate();
        }
        if (n2 != 0 && this.matrix1[n][n2 - 1] >= 0) {
            this.bricks[n][n2 - 1].rotate();
        }
        this.addBlack(n, n2);
        if (n2 != 9 && this.matrix1[n][n2 + 1] >= 0) {
            this.bricks[n][n2 + 1].rotate();
        }
        if (n != 9 && n2 != 0 && this.matrix1[n + 1][n2 - 1] >= 0) {
            this.bricks[n + 1][n2 - 1].rotate();
        }
        if (n != 9 && this.matrix1[n + 1][n2] >= 0) {
            this.bricks[n + 1][n2].rotate();
        }
        if (n != 9 && n2 != 9 && this.matrix1[n + 1][n2 + 1] >= 0) {
            this.bricks[n + 1][n2 + 1].rotate();
        }
    }

    private void analizeSpecialLightning(int n, int n2) {
        switch (this.bricks[n][n2].getOrientation()) {
            case TOP: {
                for (int i = n2; i >= 0; --i) {
                    this.addBlack(n, i);
                }
                break;
            }
            case BOTTOM: {
                for (int i = n2; i < 10; ++i) {
                    this.addBlack(n, i);
                }
                break;
            }
            case LEFT: {
                for (int i = n; i >= 0; --i) {
                    this.addBlack(i, n2);
                }
                break;
            }
            case RIGHT: {
                for (int i = n; i < 10; ++i) {
                    this.addBlack(i, n2);
                }
                break;
            }
        }
    }

    private void analizeSpecialUniversal(int n, int n2) {
        Brick brick = new Brick();
        brick.setOrientation(this.bricks[n][n2].getOrientation());
        switch (brick.getOrientation()) {
            case TOP: {
                brick.setColor(this.bricks[n][n2 - 1].getColor());
                break;
            }
            case BOTTOM: {
                brick.setColor(this.bricks[n][n2 + 1].getColor());
                break;
            }
            case LEFT: {
                brick.setColor(this.bricks[n - 1][n2].getColor());
                break;
            }
            case RIGHT: {
                brick.setColor(this.bricks[n + 1][n2].getColor());
                break;
            }
        }
        this.setBrick(n, n2, brick);
    }

    private void analizeSpecialBomb(int n, int n2) {
        if (n != 0 && n2 != 0 && this.matrix1[n - 1][n2 - 1] >= 0) {
            this.matrix1[n - 1][n2 - 1] = -1;
            this.addBlack(n - 1, n2 - 1);
        }
        if (n != 0 && this.matrix1[n - 1][n2] >= 0) {
            this.matrix1[n - 1][n2] = -1;
            this.addBlack(n - 1, n2);
        }
        if (n != 0 && n2 != 9 && this.matrix1[n - 1][n2 + 1] >= 0) {
            this.matrix1[n - 1][n2 + 1] = -1;
            this.addBlack(n - 1, n2 + 1);
        }
        if (n2 != 0 && this.matrix1[n][n2 - 1] >= 0) {
            this.matrix1[n][n2 - 1] = -1;
            this.addBlack(n, n2 - 1);
        }
        this.matrix1[n][n2] = -1;
        this.addBlack(n, n2);
        if (n2 != 9 && this.matrix1[n][n2 + 1] >= 0) {
            this.matrix1[n][n2 + 1] = -1;
            this.addBlack(n, n2 + 1);
        }
        if (n != 9 && n2 != 0 && this.matrix1[n + 1][n2 - 1] >= 0) {
            this.matrix1[n + 1][n2 - 1] = -1;
            this.addBlack(n + 1, n2 - 1);
        }
        if (n != 9 && this.matrix1[n + 1][n2] >= 0) {
            this.matrix1[n + 1][n2] = -1;
            this.addBlack(n + 1, n2);
        }
        if (n != 9 && n2 != 9 && this.matrix1[n + 1][n2 + 1] >= 0) {
            this.matrix1[n + 1][n2 + 1] = -1;
            this.addBlack(n + 1, n2 + 1);
        }
    }

    private boolean analizeSpecial() {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.matrix1[i][j] == 14) {
                    this.analizeSpecialColors(i, j);
                    return true;
                }
                if (this.matrix1[i][j] == 13) {
                    this.analizeSpecialArrows(i, j);
                    return true;
                }
                if (this.matrix1[i][j] == 12) {
                    this.analizeSpecialLightning(i, j);
                    return true;
                }
                if (this.matrix1[i][j] == 10) {
                    this.analizeSpecialUniversal(i, j);
                    return true;
                }
                if (this.matrix1[i][j] != 11) continue;
                this.analizeSpecialBomb(i, j);
                return true;
            }
        }
        return false;
    }

    public int analize() {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < 10; ++n4) {
            for (n3 = 0; n3 < 10; ++n3) {
                this.matrix1[n4][n3] = this.bricks[n4][n3].getColor().getIndex();
                this.matrix2[n4][n3] = 0;
            }
        }
        n4 = this.analizeSpecial() ? 1 : 0;
        for (n3 = 0; n3 < 10; ++n3) {
            for (n2 = 0; n2 < 10; ++n2) {
                if (this.matrix1[n3][n2] < 0) continue;
                n = 0;
                if (n3 != 0 && this.matrix1[n3 - 1][n2] == this.matrix1[n3][n2]) {
                    ++n;
                }
                if (n3 != 9 && this.matrix1[n3 + 1][n2] == this.matrix1[n3][n2]) {
                    ++n;
                }
                if (n2 != 0 && this.matrix1[n3][n2 - 1] == this.matrix1[n3][n2]) {
                    ++n;
                }
                if (n2 == 9 || this.matrix1[n3][n2 + 1] == this.matrix1[n3][n2]) {
                    // empty if block
                }
                this.matrix2[n3][n2] = ++n;
            }
        }
        for (n3 = 0; n3 < 10; ++n3) {
            for (n2 = 0; n2 < 10; ++n2) {
                if (this.matrix2[n3][n2] != 1) continue;
                n = 0;
                if (n3 != 0 && this.matrix1[n3 - 1][n2] == this.matrix1[n3][n2] && this.matrix2[n3 - 1][n2] > 1) {
                    ++n;
                }
                if (n3 != 9 && this.matrix1[n3 + 1][n2] == this.matrix1[n3][n2] && this.matrix2[n3 + 1][n2] > 1) {
                    ++n;
                }
                if (n2 != 0 && this.matrix1[n3][n2 - 1] == this.matrix1[n3][n2] && this.matrix2[n3][n2 - 1] > 1) {
                    ++n;
                }
                if (n2 != 9 && this.matrix1[n3][n2 + 1] == this.matrix1[n3][n2] && this.matrix2[n3][n2 + 1] > 1) {
                    ++n;
                }
                if (n != 0) continue;
                this.matrix2[n3][n2] = 0;
            }
        }
        n = 0;
        for (n3 = 0; n3 < 10; ++n3) {
            for (n2 = 0; n2 < 10; ++n2) {
                if (this.matrix2[n3][n2] <= 0) continue;
                this.addBlack(n3, n2);
                ++n;
            }
        }
        int n5 = n = (n = (n - 2) * 3) < 0 ? 0 : n;
        if (n == 0 && n4 != 0) {
            return -1;
        }
        return n;
    }

    private void swap(int n, int n2, int n3, int n4) {
        Brick brick = this.bricks[n][n2];
        this.bricks[n][n2] = this.bricks[n3][n4];
        this.bricks[n3][n4] = brick;
    }

    private void addBlack(int n, int n2) {
        this.list.remove(this.bricks[n][n2]);
        this.bricks[n][n2] = new Brick();
        this.list.add(this.bricks[n][n2]);
    }

    public int move() {
        int n;
        int n2;
        boolean[][] blArray = new boolean[10][10];
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 10; ++n) {
                blArray[n][n2] = false;
            }
        }
        n2 = 0;
        for (n = 0; n < 10; ++n) {
            for (int i = 0; i < 10; ++i) {
                Orientation orientation;
                if (blArray[i][n] || (orientation = this.bricks[i][n].getOrientation()) == Orientation.NONE) continue;
                if (orientation == Orientation.RIGHT) {
                    if (i + 1 == 10) {
                        this.rightBricks.shiftBack(n, this.bricks[i][n]);
                        this.addBlack(i, n);
                        ++n2;
                    } else if (this.bricks[i + 1][n].hasSameColor(BrickColor.BLACK)) {
                        this.swap(i, n, i + 1, n);
                        ++n2;
                        blArray[i + 1][n] = true;
                    }
                }
                if (orientation == Orientation.LEFT) {
                    if (i == 0) {
                        this.leftBricks.shiftBack(n, this.bricks[i][n]);
                        this.addBlack(i, n);
                        ++n2;
                    } else if (this.bricks[i - 1][n].hasSameColor(BrickColor.BLACK)) {
                        this.swap(i, n, i - 1, n);
                        ++n2;
                        blArray[i - 1][n] = true;
                    }
                }
                if (orientation == Orientation.BOTTOM) {
                    if (n + 1 == 10) {
                        this.bottomBricks.shiftBack(i, this.bricks[i][n]);
                        this.addBlack(i, n);
                        ++n2;
                    } else if (this.bricks[i][n + 1].hasSameColor(BrickColor.BLACK)) {
                        this.swap(i, n + 1, i, n);
                        ++n2;
                        blArray[i][n + 1] = true;
                    }
                }
                if (orientation != Orientation.TOP) continue;
                if (n == 0) {
                    this.topBricks.shiftBack(i, this.bricks[i][n]);
                    this.addBlack(i, n);
                    ++n2;
                    continue;
                }
                if (!this.bricks[i][n - 1].hasSameColor(BrickColor.BLACK)) continue;
                this.swap(i, n, i, n - 1);
                ++n2;
                blArray[i][n - 1] = true;
            }
        }
        return n2;
    }

    public boolean canPlay() {
        for (int i = 0; i < 10; ++i) {
            int n = this.check(i, Orientation.LEFT);
            if (n > 0 && n < 10) {
                return true;
            }
            n = this.check(i, Orientation.RIGHT);
            if (n >= 0 && n < 9) {
                return true;
            }
            n = this.check(i, Orientation.TOP);
            if (n > 0 && n < 10) {
                return true;
            }
            n = this.check(i, Orientation.BOTTOM);
            if (n < 0 || n >= 9) continue;
            return true;
        }
        return false;
    }

    public boolean isFull() {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.bricks[i][j] != null) continue;
                return false;
            }
        }
        return true;
    }
}

