/*
 * Decompiled with CFR 0.152.
 */
package elements;

import basic.Oriented;
import elements.Brick;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import values.BrickColor;
import values.GameType;
import values.Orientation;

public class BrickCollection
extends Oriented {
    private List<Brick> list = new ArrayList<Brick>();
    private List<Brick> listBackup = new ArrayList<Brick>();
    private Brick[][] bricks;
    private Brick[][] bricksBackup;
    private int maxX;
    private int maxY;
    private int level;
    private GameType type;

    public BrickCollection(int n, GameType gameType, Orientation orientation) {
        this.level = n;
        this.type = gameType;
        if (orientation.isHorizontal()) {
            this.maxX = 4;
            this.maxY = 10;
        }
        if (orientation.isVertical()) {
            this.maxX = 10;
            this.maxY = 4;
        }
        this.bricks = new Brick[this.maxX][this.maxY];
        this.bricksBackup = new Brick[this.maxX][this.maxY];
        this.fill(n, gameType);
        this.setOrientation(orientation);
    }

    public void saveToStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.level);
        for (int i = 0; i < this.maxX; ++i) {
            for (int j = 0; j < this.maxY; ++j) {
                outputStream.write(this.bricks[i][j].getColor().getIndex());
            }
        }
    }

    public void loadFromStream(InputStream inputStream) throws IOException {
        this.level = inputStream.read();
        this.list.clear();
        for (int i = 0; i < this.maxX; ++i) {
            for (int j = 0; j < this.maxY; ++j) {
                int n = inputStream.read();
                this.bricks[i][j] = n < 0 || n > 14 ? new Brick() : new Brick(new BrickColor(n));
                this.bricks[i][j].setParentCollection(this);
                this.list.add(this.bricks[i][j]);
            }
        }
    }

    public void save() {
        for (int i = 0; i < this.maxX; ++i) {
            System.arraycopy(this.bricks[i], 0, this.bricksBackup[i], 0, this.maxY);
        }
        this.listBackup.clear();
        this.listBackup.addAll(this.list);
    }

    public void restore() {
        for (int i = 0; i < this.maxX; ++i) {
            for (int j = 0; j < this.maxY; ++j) {
                this.bricks[i][j] = this.bricksBackup[i][j];
                this.bricks[i][j].setOrientation(Orientation.NONE);
            }
        }
        this.list.clear();
        this.list.addAll(this.listBackup);
    }

    private void fill(int n, GameType gameType) {
        int n2 = 0;
        for (int i = 0; i < this.maxX; ++i) {
            for (int j = 0; j < this.maxY; ++j) {
                Brick brick;
                int n3;
                while (n2 + (n3 = (brick = new Brick(n, gameType)).getColor().getIndex() >= 10 ? 1 : 0) > n / 3) {
                }
                n2 += n3;
                brick.setParentCollection(this);
                this.bricks[i][j] = brick;
                this.list.add(brick);
            }
        }
    }

    public void reInit() {
        for (int i = 0; i < this.maxX; ++i) {
            for (int j = 0; j < this.maxY; ++j) {
                if (this.bricks[i][j] != null) {
                    this.bricks[i][j].getColor().reInit();
                    this.bricks[i][j].update();
                }
                if (this.bricksBackup[i][j] == null) continue;
                this.bricksBackup[i][j].getColor().reInit();
            }
        }
    }

    public Brick getBrick(int n, int n2) {
        return this.bricks[n][n2];
    }

    public Brick[] getBrickCol(int n) {
        Brick[] brickArray = new Brick[this.maxY];
        System.arraycopy(this.bricks[n], 0, brickArray, 0, this.maxY);
        return brickArray;
    }

    public Brick[] getBrickRow(int n) {
        Brick[] brickArray = new Brick[this.maxX];
        for (int i = 0; i < this.maxX; ++i) {
            brickArray[i] = this.bricks[i][n];
        }
        return brickArray;
    }

    public boolean contains(Brick brick) {
        return this.list.contains(brick);
    }

    public Brick shift(int n) {
        if (this.getOrientation() == Orientation.NONE) {
            return null;
        }
        Brick brick = new Brick(this.level, this.type);
        brick.setParentCollection(this);
        if (this.getOrientation() == Orientation.LEFT) {
            this.list.remove(this.bricks[this.maxX - 1][n]);
            for (int i = this.maxX - 1; i > 0; --i) {
                this.bricks[i][n] = this.bricks[i - 1][n];
            }
            this.bricks[0][n] = brick;
        } else if (this.getOrientation() == Orientation.RIGHT) {
            this.list.remove(this.bricks[0][n]);
            for (int i = 0; i < this.maxX - 1; ++i) {
                this.bricks[i][n] = this.bricks[i + 1][n];
            }
            this.bricks[this.maxX - 1][n] = brick;
        } else if (this.getOrientation() == Orientation.TOP) {
            this.list.remove(this.bricks[n][this.maxY - 1]);
            for (int i = this.maxY - 1; i > 0; --i) {
                this.bricks[n][i] = this.bricks[n][i - 1];
            }
            this.bricks[n][0] = brick;
        } else if (this.getOrientation() == Orientation.BOTTOM) {
            this.list.remove(this.bricks[n][0]);
            System.arraycopy(this.bricks[n], 1, this.bricks[n], 0, this.maxY - 1);
            this.bricks[n][this.maxY - 1] = brick;
        }
        this.list.add(brick);
        return brick;
    }

    public void shiftBack(int n, Brick brick) {
        if (this.getOrientation() == Orientation.NONE) {
            return;
        }
        brick.setOrientation(Orientation.NONE);
        brick.setParentCollection(this);
        if (this.getOrientation() == Orientation.RIGHT) {
            this.list.remove(this.bricks[this.maxX - 1][n]);
            for (int i = this.maxX - 1; i > 0; --i) {
                this.bricks[i][n] = this.bricks[i - 1][n];
            }
            this.bricks[0][n] = brick;
        } else if (this.getOrientation() == Orientation.LEFT) {
            this.list.remove(this.bricks[0][n]);
            for (int i = 0; i < this.maxX - 1; ++i) {
                this.bricks[i][n] = this.bricks[i + 1][n];
            }
            this.bricks[this.maxX - 1][n] = brick;
        } else if (this.getOrientation() == Orientation.BOTTOM) {
            this.list.remove(this.bricks[n][this.maxY - 1]);
            for (int i = this.maxY - 1; i > 0; --i) {
                this.bricks[n][i] = this.bricks[n][i - 1];
            }
            this.bricks[n][0] = brick;
        } else if (this.getOrientation() == Orientation.TOP) {
            this.list.remove(this.bricks[n][0]);
            System.arraycopy(this.bricks[n], 1, this.bricks[n], 0, this.maxY - 1);
            this.bricks[n][this.maxY - 1] = brick;
        }
        this.list.add(brick);
    }

    public void setType(GameType gameType) {
        this.type = gameType;
    }
}

