/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.repo.RepoDescriptor;
import org.apache.ivy.osgi.util.Version;

public class P2Descriptor
extends RepoDescriptor {
    private long timestamp;
    private Map artifactUrlPatterns = new HashMap();
    private String repoUrl;

    public P2Descriptor(URI repoUri, ExecutionEnvironmentProfileProvider profileProvider) {
        super(repoUri, profileProvider);
        try {
            this.repoUrl = repoUri.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Illegal repo uri", e);
        }
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void addBundle(BundleInfo bundleInfo) {
        String urlPattern;
        Map urlPatternsByVersion = (Map)this.artifactUrlPatterns.get(bundleInfo.getSymbolicName());
        if (urlPatternsByVersion != null && (urlPattern = (String)urlPatternsByVersion.get(bundleInfo.getVersion())) != null) {
            String url = urlPattern.replaceAll("\\$\\{id\\}", bundleInfo.getSymbolicName());
            url = url.replaceAll("\\$\\{version\\}", bundleInfo.getVersion().toString());
            try {
                bundleInfo.setUri(new URI(url));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to build the artifact uri of " + bundleInfo, e);
            }
            super.addBundle(bundleInfo);
        }
    }

    public void addArtifactUrl(String classifier, String id, Version version, String url) {
        if (!classifier.equals("osgi.bundle")) {
            return;
        }
        HashMap<Version, String> byVersion = (HashMap<Version, String>)this.artifactUrlPatterns.get(id);
        if (byVersion == null) {
            byVersion = new HashMap<Version, String>();
            this.artifactUrlPatterns.put(id, byVersion);
        }
        byVersion.put(version, url);
    }
}

