/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GFile;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface FSBNode
extends GTreeNode {
    public FSRL getFSRL();

    public static FSBRootNode findContainingFileSystemFSBRootNode(FSBNode node) {
        GTreeNode parent;
        for (parent = node.getParent(); parent != null && !(parent instanceof FSBRootNode); parent = parent.getParent()) {
        }
        return parent instanceof FSBRootNode ? (FSBRootNode)parent : null;
    }

    public static List<GTreeNode> getNodesFromFileList(List<GFile> files) {
        ArrayList<GTreeNode> nodes = new ArrayList<GTreeNode>(files.size());
        Collections.sort(files, FSUtilities.GFILE_NAME_TYPE_COMPARATOR);
        for (GFile child : files) {
            nodes.add(FSBNode.getNodeFromFile(child));
        }
        return nodes;
    }

    public static FSBNode getNodeFromFile(GFile file) {
        return file.isDirectory() ? new FSBDirNode(file.getFSRL()) : new FSBFileNode(file.getFSRL());
    }
}

