/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.framework.main.ConsoleListener;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Font;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ConsoleTextPane
extends JTextPane
implements OptionsChangeListener {
    private static final String CUSTOM_ATTRIBUTE_KEY = ConsoleTextPane.class.getName();
    private static final String OUTPUT_ATTRIBUTE_VALUE = "OUTPUT";
    private static final String ERROR_ATTRIBUTE_VALUE = "ERROR";
    private static final String OPTIONS_NAME = "Console";
    private static final String MAXIMUM_CHARACTERS_OPTION_NAME = "Character Limit";
    private static final String TRUNCTION_FACTOR_OPTION_NAME = "Truncation Factor";
    private static final int QUEUED_MESSAGE_LIMIT = 20;
    private static int MAXIMUM_CHARS = 50000;
    private static double TRUNCTION_FACTOR = 0.1;
    private static SimpleAttributeSet outputAttributeSet;
    private static SimpleAttributeSet errorAttributeSet;
    private SwingUpdateManager updateManager = new SwingUpdateManager(1, 500, () -> this.doUpdate());
    private List<MessageWrapper> messageList = Collections.synchronizedList(new LinkedList());
    private ConsoleListener listener;
    private boolean scrollLock;
    private int maximumCharacterLimit = MAXIMUM_CHARS;
    private double truncationFactor = TRUNCTION_FACTOR;
    private int truncationAmount = (int)((double)MAXIMUM_CHARS * TRUNCTION_FACTOR);
    private int queuedMessageCount;

    public ConsoleTextPane(PluginTool tool) {
        this.createAttribtues();
        this.setEditable(true);
        ToolOptions options = tool.getOptions(OPTIONS_NAME);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.initOptions((Options)options);
    }

    public void setScrollLock(boolean lock) {
        this.scrollLock = lock;
        this.updateCaretSelectionPolicy(lock);
    }

    public void setConsoleListener(ConsoleListener listener) {
        this.listener = listener;
    }

    public void addMessage(String message) {
        this.doAddMessage(new MessageWrapper(message, true));
    }

    public void addPartialMessage(String message) {
        this.doAddMessage(new MessageWrapper(message, false));
    }

    public void addErrorMessage(String message) {
        this.doAddMessage(new ErrorMessage(message, true));
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        if (MAXIMUM_CHARACTERS_OPTION_NAME.equals(name) || TRUNCTION_FACTOR_OPTION_NAME.equals(name)) {
            this.updateFromOptions((Options)options);
        }
    }

    private void initOptions(Options options) {
        options.registerOption(MAXIMUM_CHARACTERS_OPTION_NAME, (Object)MAXIMUM_CHARS, null, "The maximum number of characters to display before truncating characters from the top of the console.");
        options.registerOption(TRUNCTION_FACTOR_OPTION_NAME, (Object)TRUNCTION_FACTOR, null, "The factor (when multiplied by the Character Limit) by which to remove characters when truncating is necessary.");
        this.updateFromOptions(options);
    }

    private void updateFromOptions(Options options) {
        int newLimit = options.getInt(MAXIMUM_CHARACTERS_OPTION_NAME, MAXIMUM_CHARS);
        this.truncationFactor = options.getDouble(TRUNCTION_FACTOR_OPTION_NAME, TRUNCTION_FACTOR);
        this.setMaximumCharacterLimit(newLimit);
    }

    void setMaximumCharacterLimit(int limit) {
        this.maximumCharacterLimit = limit;
        this.truncationAmount = (int)((double)this.maximumCharacterLimit * this.truncationFactor);
    }

    private void updateCaretSelectionPolicy(boolean lockSelection) {
        Caret caret = this.getCaret();
        if (caret instanceof DefaultCaret) {
            DefaultCaret defaultCaret = (DefaultCaret)caret;
            if (lockSelection) {
                defaultCaret.setUpdatePolicy(1);
            } else {
                defaultCaret.setUpdatePolicy(2);
            }
        }
    }

    private void doAddMessage(MessageWrapper messageWrapper) {
        this.messageList.add(messageWrapper);
        this.updateManager.update();
        if (this.queuedMessageCount++ > 20) {
            this.queuedMessageCount = 0;
            Thread.yield();
        }
    }

    @Override
    public void setFont(Font font) {
        this.createAttributes(font);
        this.updateCurrentTextWithNewFont();
        super.setFont(font);
    }

    private void updateCurrentTextWithNewFont() {
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        SystemUtilities.assertTrue((boolean)(document instanceof StyledDocument), (String)(this.getClass().getName() + " is designed to work with StyledDocuments"));
        StyledDocument styledDocument = (StyledDocument)document;
        int length = document.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = styledDocument.getCharacterElement(i);
            AttributeSet attributes = element.getAttributes();
            Object attribute = attributes.getAttribute(CUSTOM_ATTRIBUTE_KEY);
            if (OUTPUT_ATTRIBUTE_VALUE.equals(attribute)) {
                styledDocument.setCharacterAttributes(i, 1, outputAttributeSet, true);
                continue;
            }
            if (ERROR_ATTRIBUTE_VALUE.equals(attribute)) {
                styledDocument.setCharacterAttributes(i, 1, errorAttributeSet, true);
                continue;
            }
            throw new AssertException("Unexpected attribute type for text");
        }
    }

    private void createAttribtues() {
        this.createAttributes(new Font("monospaced", 0, 12));
    }

    private void createAttributes(Font font) {
        outputAttributeSet = new SimpleAttributeSet();
        outputAttributeSet.addAttribute(CUSTOM_ATTRIBUTE_KEY, OUTPUT_ATTRIBUTE_VALUE);
        outputAttributeSet.addAttribute(StyleConstants.FontFamily, font.getFamily());
        outputAttributeSet.addAttribute(StyleConstants.FontSize, font.getSize());
        outputAttributeSet.addAttribute(StyleConstants.Italic, font.isItalic());
        outputAttributeSet.addAttribute(StyleConstants.Bold, font.isBold());
        outputAttributeSet.addAttribute(StyleConstants.Foreground, Color.BLACK);
        errorAttributeSet = new SimpleAttributeSet();
        errorAttributeSet.addAttribute(CUSTOM_ATTRIBUTE_KEY, ERROR_ATTRIBUTE_VALUE);
        errorAttributeSet.addAttribute(StyleConstants.FontFamily, font.getFamily());
        errorAttributeSet.addAttribute(StyleConstants.FontSize, font.getSize());
        errorAttributeSet.addAttribute(StyleConstants.Italic, font.isItalic());
        errorAttributeSet.addAttribute(StyleConstants.Bold, font.isBold());
        errorAttributeSet.addAttribute(StyleConstants.Foreground, Color.RED);
    }

    private void insertString(String message, AttributeSet attributeSet) {
        Document document = this.getDocument();
        int offset = document.getLength();
        try {
            document.insertString(offset, message, attributeSet);
        }
        catch (BadLocationException e) {
            Msg.debug((Object)this, (Object)"Unexpected exception updating text", (Throwable)e);
        }
    }

    private void doUpdate() {
        int i = 0;
        while (!this.messageList.isEmpty()) {
            MessageWrapper messageWrapper = this.messageList.remove(0);
            String message = messageWrapper.getMessage();
            this.insertString(message, messageWrapper.getAttributes());
            this.validateCapacity();
            this.notifyListener(messageWrapper);
            if (i % 1000 == 0) {
                this.paintImmediately(this.getBounds());
            }
            ++i;
        }
        this.updateView();
    }

    private void notifyListener(MessageWrapper messageWrapper) {
        if (this.listener != null) {
            if (messageWrapper.isDoNewline()) {
                this.listener.putln(messageWrapper.getMessage(), messageWrapper instanceof ErrorMessage);
            } else {
                this.listener.put(messageWrapper.getMessage(), messageWrapper instanceof ErrorMessage);
            }
        }
    }

    private void updateView() {
        if (this.scrollLock) {
            return;
        }
        Document doc = this.getDocument();
        int length = doc.getLength();
        this.setCaretPosition(length);
    }

    private void validateCapacity() {
        Document doc = this.getDocument();
        int length = doc.getLength();
        if (length > this.maximumCharacterLimit) {
            int overage = length - this.maximumCharacterLimit;
            int totalToTrim = overage + this.truncationAmount;
            try {
                doc.remove(0, totalToTrim);
            }
            catch (BadLocationException e) {
                Msg.debug((Object)this, (Object)"Unexpected exception updating text", (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.updateManager.dispose();
    }

    private static class ErrorMessage
    extends MessageWrapper {
        private ErrorMessage(String message, boolean doNewline) {
            super(message, doNewline);
        }

        @Override
        AttributeSet getAttributes() {
            return errorAttributeSet;
        }
    }

    private static class MessageWrapper {
        private final String message;
        private final boolean doNewline;

        private MessageWrapper(String message, boolean doNewline) {
            if (message == null) {
                throw new AssertException("Attempted to log a null message.");
            }
            this.message = message;
            this.doNewline = doNewline;
        }

        public boolean isDoNewline() {
            return this.doNewline;
        }

        String getMessage() {
            return this.message;
        }

        AttributeSet getAttributes() {
            return outputAttributeSet;
        }
    }
}

