/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.Project;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.PrintWriter;

@ExtensionPoint.Exclude(reason="requires explicit instantiation to wrap a script")
public class GhidraScriptAnalyzerAdapter
extends AbstractAnalyzer {
    private ResourceFile scriptFile;
    private GhidraScript script;
    private PrintWriter writer;

    public GhidraScriptAnalyzerAdapter(ResourceFile file, AnalyzerType analyzerType, int priority) {
        super("Script: " + file.getName(), GhidraScriptAnalyzerAdapter.getDescription(file), analyzerType);
        this.scriptFile = file;
        this.setDefaultEnablement(true);
        this.setPriority(new AnalysisPriority(priority));
        this.writer = new PrintWriter(System.out);
        this.script = this.getGhidraScript();
    }

    private static String getDescription(ResourceFile file) {
        return GhidraScriptUtil.getScriptInfo(file).getDescription();
    }

    public void setPrintWriter(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (this.script == null) {
            return false;
        }
        ProgramLocation loc = new ProgramLocation(program, set.getMinAddress());
        ProgramSelection selection = new ProgramSelection(set);
        Project project = null;
        GhidraState scriptState = new GhidraState(null, project, program, loc, selection, null);
        return GhidraScriptUtil.runScript(scriptState, this.script, this.writer, this, monitor);
    }

    private GhidraScript getGhidraScript() {
        GhidraScriptProvider provider = GhidraScriptUtil.getProvider(this.scriptFile);
        try {
            return provider.getScriptInstance(this.scriptFile, this.writer);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Error compiling script: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getScriptName() {
        return this.scriptFile.getName();
    }
}

