/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributeException;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class SymbolTableXmlMgr {
    private Program program;
    private SymbolTable symbolTable;
    private MessageLog log;
    private AddressFactory factory;
    private boolean overwritePrimary;
    private boolean secondPassRequired = false;

    SymbolTableXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.log = log;
        this.symbolTable = program.getSymbolTable();
        this.factory = program.getAddressFactory();
    }

    boolean isSecondPassRequired() {
        return this.secondPassRequired;
    }

    void read(XmlPullParser parser, boolean isOverwritePrimary, TaskMonitor monitor) throws CancelledException {
        this.read(parser, isOverwritePrimary, 1, monitor);
    }

    void readPass2(XmlPullParser parser, boolean isOverwritePrimary, TaskMonitor monitor) throws CancelledException {
        this.read(parser, isOverwritePrimary, 2, monitor);
    }

    private void read(XmlPullParser parser, boolean isOverwritePrimary, int passNumber, TaskMonitor monitor) throws CancelledException {
        this.overwritePrimary = isOverwritePrimary;
        XmlElement symbolTableElement = parser.start(new String[]{"SYMBOL_TABLE"});
        while (parser.peek().isStart()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            XmlElement symbolElement = parser.start(new String[]{"SYMBOL"});
            this.processSymbol(symbolElement, parser, passNumber);
            parser.end(symbolElement);
        }
        parser.end(symbolTableElement);
    }

    void write(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing SYMBOL TABLE ...");
        writer.startElement("SYMBOL_TABLE");
        SymbolIterator iter = this.symbolTable.getSymbolIterator();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Symbol symbol = iter.next();
            SymbolType symbolType = symbol.getSymbolType();
            if (symbol.getSource() == SourceType.DEFAULT || symbolType != SymbolType.CODE && symbolType != SymbolType.FUNCTION) continue;
            Address addr = symbol.getAddress();
            if (set != null && !set.contains(addr)) continue;
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)addr));
            attrs.addAttribute("NAME", symbol.getName());
            attrs.addAttribute("NAMESPACE", this.getNamespace(symbol));
            String type = this.checkGlobal(symbol) ? "global" : "local";
            attrs.addAttribute("TYPE", type);
            SourceType source = symbol.getSource();
            attrs.addAttribute("SOURCE_TYPE", source.toString());
            attrs.addAttribute("PRIMARY", symbol.isPrimary() ? "y" : "n");
            writer.startElement("SYMBOL", attrs);
            writer.endElement("SYMBOL");
        }
        writer.endElement("SYMBOL_TABLE");
    }

    private boolean checkGlobal(Symbol symbol) {
        if (symbol.isGlobal()) {
            return true;
        }
        Namespace parent = symbol.getParentNamespace();
        return !(parent.getSymbol() instanceof FunctionSymbol);
    }

    private String getNamespace(Symbol symbol) {
        StringBuffer buffer = new StringBuffer();
        for (Namespace namespace = symbol.getParentNamespace(); namespace != this.program.getGlobalNamespace(); namespace = namespace.getParentNamespace()) {
            buffer.insert(0, namespace.getName() + "::");
        }
        return buffer.toString();
    }

    private void processSymbol(XmlElement element, XmlPullParser parser, int passNumber) {
        try {
            boolean isDefaultFunctionName;
            String type = element.getAttribute("TYPE");
            boolean isLocal = type != null && type.equalsIgnoreCase("local");
            Object name = element.getAttribute("NAME");
            boolean bl = isDefaultFunctionName = name != null && (((String)name).startsWith("FUN_") || ((String)name).startsWith("thunk_"));
            if (isLocal || isDefaultFunctionName) {
                if (passNumber != 2) {
                    this.secondPassRequired = true;
                    return;
                }
            } else if (passNumber == 2) {
                return;
            }
            String addrStr = element.getAttribute("ADDRESS");
            String namespace = element.getAttribute("NAMESPACE");
            String primary = element.getAttribute("PRIMARY");
            String sourceTypeString = element.getAttribute("SOURCE_TYPE");
            boolean isPrimary = primary == null || primary.equalsIgnoreCase("y");
            SourceType sourceType = SourceType.USER_DEFINED;
            try {
                if (sourceTypeString != null) {
                    sourceType = SourceType.valueOf((String)sourceTypeString);
                }
            }
            catch (IllegalArgumentException iae) {
                this.log.appendMsg("Unknown SourceType: " + sourceTypeString);
            }
            Address addr = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)addrStr);
            if (addr == null) {
                throw new XmlAttributeException("Incompatible Symbol Address: " + addrStr);
            }
            if (name == null) {
                throw new XmlAttributeException("Missing required symbol name for address: " + addrStr);
            }
            Namespace localNamespace = this.symbolTable.getNamespace(addr);
            Namespace scope = this.program.getGlobalNamespace();
            if (isLocal) {
                scope = localNamespace;
            } else if (localNamespace != null && localNamespace.getName().equalsIgnoreCase(namespace)) {
                scope = localNamespace;
            } else if (namespace != null && namespace.length() != 0) {
                if (this.program.getGlobalNamespace().equals(localNamespace)) {
                    scope = NamespaceUtils.createNamespaceHierarchy((String)namespace, (Namespace)this.program.getGlobalNamespace(), (Program)this.program, (SourceType)sourceType);
                } else {
                    name = namespace + (String)name;
                }
            }
            Symbol s = this.symbolTable.getPrimarySymbol(addr);
            if (((String)name).startsWith("thunk_")) {
                if (s == null || s.getSymbolType() != SymbolType.FUNCTION) {
                    this.log.appendMsg("Thunk symbol ignored at non-function location: " + addr);
                    return;
                }
                Function f = (Function)s.getObject();
                if (!f.isThunk()) {
                    String thunkedName = ((String)name).substring(6);
                    Symbol symbol = SymbolUtilities.getExpectedLabelOrFunctionSymbol((Program)this.program, (String)thunkedName, err -> this.log.error(null, err));
                    if (symbol == null || symbol.getSymbolType() != SymbolType.FUNCTION) {
                        this.log.appendMsg("Failed to establish thunk function for function at: " + addr);
                        return;
                    }
                    f.setThunkedFunction((Function)symbol.getObject());
                }
            } else if (s != null && (!s.getName().equals(name) || scope.equals(s.getParentNamespace()))) {
                s = this.symbolTable.getSymbol((String)name, addr, scope);
            }
            if (s == null) {
                s = SymbolUtilities.createPreferredLabelOrFunctionSymbol((Program)this.program, (Address)addr, (Namespace)scope, (String)name, (SourceType)sourceType);
            }
            if (isPrimary && this.overwritePrimary) {
                s.setPrimary();
            }
            if (sourceType != SourceType.DEFAULT) {
                s.setSource(sourceType);
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }
}

