/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LoaderService {
    public static Predicate<Loader> ACCEPT_ALL = loader -> true;

    public static Map<Loader, Collection<LoadSpec>> getSupportedLoadSpecs(ByteProvider provider, Predicate<Loader> loaderFilter) {
        LinkedHashMap<Loader, Collection<LoadSpec>> loadMap = new LinkedHashMap<Loader, Collection<LoadSpec>>();
        for (Loader loader : LoaderService.getAllLoaders()) {
            if (!loaderFilter.test(loader)) continue;
            try {
                Collection<LoadSpec> loadSpecs = loader.findSupportedLoadSpecs(provider);
                if (loadSpecs == null || loadSpecs.isEmpty()) continue;
                loadMap.put(loader, loadSpecs);
            }
            catch (IOException loadSpecs) {
            }
            catch (RuntimeException e) {
                Msg.error(LoaderService.class, (Object)("Unexpected Loader exception from " + loader.getName()), (Throwable)e);
            }
        }
        return loadMap;
    }

    public static Map<Loader, Collection<LoadSpec>> getAllSupportedLoadSpecs(ByteProvider provider) {
        return LoaderService.getSupportedLoadSpecs(provider, ACCEPT_ALL);
    }

    public static Collection<String> getAllLoaderNames() {
        return LoaderService.getAllLoaders().stream().map(loader -> loader.getName()).collect(Collectors.toList());
    }

    public static Class<? extends Loader> getLoaderClassByName(String name) {
        return LoaderService.getAllLoaders().stream().filter(loader -> loader.getClass().getSimpleName().equals(name)).findFirst().map(loader -> loader.getClass()).orElse(null);
    }

    private static synchronized Collection<Loader> getAllLoaders() {
        ArrayList<Loader> loaders = new ArrayList<Loader>(ClassSearcher.getInstances(Loader.class));
        Collections.sort(loaders);
        return loaders;
    }
}

