/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MemoryConflictHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.local.ItemSerializer;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class GdtLoader
implements Loader {
    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        return Collections.emptyList();
    }

    @Override
    public List<DomainObject> load(ByteProvider provider, String filename, DomainFolder programFolder, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        DomainFile df = this.doImport(provider, filename, programFolder, monitor);
        monitor.setMessage("Opening " + filename);
        DomainObject dobj = df.getDomainObject(consumer, true, false, monitor);
        if (!(dobj instanceof DataTypeArchive)) {
            if (dobj != null) {
                dobj.release(consumer);
                df.delete();
            }
            throw new IOException("File imported is not a Data Type Archive: " + filename);
        }
        ArrayList<DomainObject> results = new ArrayList<DomainObject>();
        results.add(dobj);
        return results;
    }

    private DomainFile doImport(ByteProvider provider, String filename, DomainFolder programFolder, TaskMonitor monitor) throws InvalidNameException, CancelledException, IOException {
        File file = provider.getFile();
        DomainFolder folder = programFolder;
        monitor.setMessage("Restoring " + file.getName());
        DomainFile df = folder.createFile(filename, file, monitor);
        return df;
    }

    @Override
    public boolean loadInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Program program, TaskMonitor monitor, MemoryConflictHandler memoryConflictHandler) throws IOException, CancelledException {
        throw new UnsupportedOperationException("cannot add GDT to program");
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options) {
        if (options != null && options.size() > 0) {
            return "GDTLoader takes no options";
        }
        return null;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (GdtLoader.isGDTFile(provider)) {
            loadSpecs.add(new LoadSpec((Loader)this, 0L, false));
        }
        return loadSpecs;
    }

    @Override
    public String getPreferredFileName(ByteProvider provider) {
        return FilenameUtils.removeExtension((String)provider.getName());
    }

    private static boolean isGDTFile(ByteProvider provider) {
        if (!provider.getName().toLowerCase().endsWith(".gdt")) {
            return false;
        }
        boolean isGDT = false;
        try (InputStream inputStream = provider.getInputStream(0L);){
            isGDT = ItemSerializer.isPackedFile((InputStream)inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isGDT;
    }

    @Override
    public String getName() {
        return "Ghidra Data Type Archive Format";
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.SPECIALIZED_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 0;
    }
}

