/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import ghidra.app.util.importer.LoadSpecChooser;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.util.Msg;
import java.util.List;

public class LcsHintLoadSpecChooser
implements LoadSpecChooser {
    private final LanguageID languageID;
    private final CompilerSpecID compilerSpecID;

    public LcsHintLoadSpecChooser(Language language, CompilerSpec compilerSpec) {
        this.languageID = language.getLanguageID();
        this.compilerSpecID = compilerSpec == null ? null : compilerSpec.getCompilerSpecID();
    }

    @Override
    public LoadSpec choose(List<LoadSpec> loadSpecs) {
        LanguageCompilerSpecPair lcsPair;
        for (LoadSpec loadSpec : loadSpecs) {
            if (loadSpec == null) {
                Msg.warn((Object)this, (Object)"found null load spec whilst trying to choose");
                continue;
            }
            if (!loadSpec.isPreferred()) continue;
            lcsPair = loadSpec.getLanguageCompilerSpec();
            if (lcsPair == null) {
                Msg.warn((Object)this, (Object)("load spec " + loadSpec + " proffered null LCS pair whilst trying to choose"));
                continue;
            }
            if (!lcsPair.languageID.equals((Object)this.languageID) || this.compilerSpecID != null && !lcsPair.compilerSpecID.equals((Object)this.compilerSpecID)) continue;
            return loadSpec;
        }
        for (LoadSpec loadSpec : loadSpecs) {
            if (loadSpec == null) {
                Msg.warn((Object)this, (Object)"found null load spec whilst trying to choose");
                continue;
            }
            lcsPair = loadSpec.getLanguageCompilerSpec();
            if (lcsPair == null) {
                Msg.warn((Object)this, (Object)("load spec " + loadSpec + " proffered null LCS pair whilst trying to choose"));
                continue;
            }
            if (!lcsPair.languageID.equals((Object)this.languageID) || this.compilerSpecID != null && !lcsPair.compilerSpecID.equals((Object)this.compilerSpecID)) continue;
            return loadSpec;
        }
        return null;
    }

    @Override
    public boolean usePreferred() {
        return false;
    }
}

