/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TypeDefDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private final TypeDef typeDef;
    private List<String> warningLines;
    protected List<ValidatableLine> headerContent;
    protected List<ValidatableLine> bodyContent;

    private TypeDefDataTypeHTMLRepresentation(TypeDef typeDef, List<String> warningLines, List<ValidatableLine> headerLines, List<ValidatableLine> bodyLines) {
        this.typeDef = typeDef;
        this.warningLines = warningLines;
        this.headerContent = headerLines;
        this.bodyContent = bodyLines;
        this.originalHTMLData = TypeDefDataTypeHTMLRepresentation.buildHTMLText(typeDef, warningLines, headerLines, bodyLines);
    }

    public TypeDefDataTypeHTMLRepresentation(TypeDef typeDef) {
        this.typeDef = typeDef;
        this.warningLines = this.buildWarnings();
        this.headerContent = this.buildHeaderText((DataType)typeDef);
        this.bodyContent = this.buildBodyText(this.getBaseDataType());
        this.originalHTMLData = TypeDefDataTypeHTMLRepresentation.buildHTMLText(typeDef, this.warningLines, this.headerContent, this.bodyContent);
    }

    protected DataType getBaseDataType() {
        return TypeDefDataTypeHTMLRepresentation.getBaseDataType((DataType)this.typeDef);
    }

    private static DataType getBaseDataType(DataType dataType) {
        DataType basedataType = dataType;
        while (basedataType instanceof TypeDef) {
            basedataType = ((TypeDef)basedataType).getDataType();
            while (basedataType instanceof Pointer) {
                basedataType = ((Pointer)basedataType).getDataType();
            }
        }
        return basedataType;
    }

    protected List<String> buildWarnings() {
        DataType baseType = this.typeDef.getBaseDataType();
        if (!(baseType instanceof Composite) || !baseType.isNotYetDefined()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("WARNING! Refers to Empty " + (baseType instanceof Structure ? "Structure" : "Union"));
        return list;
    }

    @Override
    protected TextLine buildFooterText(DataType dataType) {
        if (dataType.isNotYetDefined()) {
            return new TextLine("0");
        }
        return super.buildFooterText(dataType);
    }

    @Override
    protected List<ValidatableLine> buildHeaderText(DataType dataType) {
        TypeDef basedataType = this.typeDef;
        ArrayList<ValidatableLine> lines = new ArrayList<ValidatableLine>();
        while (basedataType instanceof TypeDef) {
            StringBuilder buffy = new StringBuilder();
            String baseDtString = basedataType.toString();
            String encodedBaseDt = HTMLUtilities.friendlyEncodeHTML((String)baseDtString);
            buffy.append("<TT>").append(encodedBaseDt).append("</TT>").append("<BR>");
            lines.add(new TextLine(buffy.toString()));
            basedataType = basedataType.getDataType();
            while (basedataType instanceof Pointer) {
                basedataType = ((Pointer)basedataType).getDataType();
            }
        }
        return lines;
    }

    private List<ValidatableLine> buildBodyText(DataType baseDataType) {
        ArrayList<ValidatableLine> lines = new ArrayList<ValidatableLine>();
        if (baseDataType instanceof BuiltInDataType) {
            TypeDefDataTypeHTMLRepresentation.buildHTMLTextForBuiltIn(lines, baseDataType);
        } else {
            TypeDefDataTypeHTMLRepresentation.buildHTMLTextForBaseDataType(lines, baseDataType);
        }
        return lines;
    }

    private static String buildHTMLText(TypeDef typeDef, List<String> warningLines, List<ValidatableLine> headerLines, List<ValidatableLine> bodyLines) {
        StringBuffer buffy = new StringBuffer();
        for (String warning : warningLines) {
            String string = TypeDefDataTypeHTMLRepresentation.wrapStringInColor(warning, Color.RED);
            buffy.append(string).append("<BR>");
        }
        for (TextLine textLine : headerLines) {
            String headerLine = TypeDefDataTypeHTMLRepresentation.wrapStringInColor(textLine.getText(), textLine.getTextColor());
            buffy.append(headerLine);
        }
        buffy.append("<BR>");
        buffy.append("TypeDef Base Data Type: ").append("<BR>").append("<BR>");
        for (TextLine textLine : bodyLines) {
            String bodyLine = TypeDefDataTypeHTMLRepresentation.wrapStringInColor(textLine.getText(), textLine.getTextColor());
            buffy.append(bodyLine);
        }
        return buffy.toString();
    }

    private static void buildHTMLTextForBuiltIn(List<ValidatableLine> lines, DataType basedataType) {
        lines.add(new TextLine("<P STYLE='margin-left: 10px;'>"));
        lines.add(new TextLine("<TT>"));
        String dataTypeDescriptionOrName = TypeDefDataTypeHTMLRepresentation.getDataTypeDescriptionOrName(basedataType);
        String encodedDescriptionOrName = HTMLUtilities.friendlyEncodeHTML((String)dataTypeDescriptionOrName);
        lines.add(new TextLine(encodedDescriptionOrName));
        lines.add(new TextLine("</TT>"));
        StringBuffer buffy = TypeDefDataTypeHTMLRepresentation.addDataTypeLength(basedataType, new StringBuffer());
        lines.add(new TextLine(buffy.toString()));
        lines.add(new TextLine("</P>"));
    }

    private static String getDataTypeDescriptionOrName(DataType dataType) {
        String description = dataType.getDescription();
        if (description == null || description.length() == 0) {
            return dataType.getName();
        }
        return description;
    }

    private static void buildHTMLTextForBaseDataType(List<ValidatableLine> lines, DataType basedataType) {
        lines.add(new TextLine("<P STYLE='margin-left: 10px;'>"));
        HTMLDataTypeRepresentation baseRepresentation = ToolTipUtils.getHTMLRepresentation(basedataType);
        String baseHTML = baseRepresentation.getHTMLContentString();
        lines.add(new TextLine(baseHTML));
        if (baseHTML.indexOf("Length: ") < 0) {
            StringBuffer buffy = TypeDefDataTypeHTMLRepresentation.addDataTypeLength(basedataType, new StringBuffer());
            lines.add(new TextLine(buffy.toString()));
        }
        lines.add(new TextLine("</P>"));
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof TypeDefDataTypeHTMLRepresentation)) {
            return this.completelyDifferentDiff(otherRepresentation);
        }
        TypeDefDataTypeHTMLRepresentation typeDefRepresentation = (TypeDefDataTypeHTMLRepresentation)otherRepresentation;
        DataType myBaseDataType = this.getBaseDataType();
        DataType otherBaseDataType = typeDefRepresentation.getBaseDataType();
        HTMLDataTypeRepresentation myBaseRepresentation = ToolTipUtils.getHTMLRepresentation(myBaseDataType);
        HTMLDataTypeRepresentation otherBaseRepresentation = ToolTipUtils.getHTMLRepresentation(otherBaseDataType);
        HTMLDataTypeRepresentation[] diffs = this.doDiff(myBaseRepresentation, otherBaseRepresentation);
        ArrayList<ValidatableLine> header = new ArrayList<ValidatableLine>(this.headerContent);
        ArrayList<ValidatableLine> body = new ArrayList<ValidatableLine>();
        if (diffs != null) {
            body.add(new TextLine(diffs[0].getHTMLContentString()));
        }
        ArrayList<ValidatableLine> otherHeader = new ArrayList<ValidatableLine>(typeDefRepresentation.headerContent);
        ArrayList<ValidatableLine> otherBody = new ArrayList<ValidatableLine>();
        if (diffs != null) {
            otherBody.add(new TextLine(diffs[1].getHTMLContentString()));
        }
        DataTypeDiff headerDiff = DataTypeDiffBuilder.diffHeader(this.getDiffInput(header), this.getDiffInput(otherHeader));
        List<String> noWarnings = Collections.emptyList();
        return new HTMLDataTypeRepresentation[]{new TypeDefDataTypeHTMLRepresentation(this.typeDef, noWarnings, headerDiff.getLeftLines(), body), new TypeDefDataTypeHTMLRepresentation(typeDefRepresentation.typeDef, noWarnings, headerDiff.getRightLines(), otherBody)};
    }

    private HTMLDataTypeRepresentation[] doDiff(HTMLDataTypeRepresentation myBaseRepresentation, HTMLDataTypeRepresentation otherBaseRepresentation) {
        HTMLDataTypeRepresentation[] diffs = myBaseRepresentation.diff(otherBaseRepresentation);
        return diffs;
    }
}

