/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.HTMLUtilities;
import java.awt.Color;

public class ArrayDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private ValidatableLine headerContent;
    private String bodyHtml;
    private ValidatableLine footerContent;
    private Array array;

    public ArrayDataTypeHTMLRepresentation(Array array) {
        this.array = array;
        this.headerContent = this.buildHeaderContent();
        this.bodyHtml = this.buildBodyHTML();
        this.footerContent = this.buildFooterContent();
        this.originalHTMLData = this.buildHTMLText(this.headerContent, this.bodyHtml, this.footerContent);
    }

    private ArrayDataTypeHTMLRepresentation(Array array, ValidatableLine headerContent, String bodyHtml, ValidatableLine footerContent) {
        this.array = array;
        this.headerContent = headerContent;
        this.bodyHtml = bodyHtml;
        this.footerContent = footerContent;
        this.originalHTMLData = this.buildHTMLText(headerContent, bodyHtml, footerContent);
    }

    private DataType getBaseDataType() {
        Array baseDataType = this.array;
        while (baseDataType instanceof Array) {
            Array baseArray = baseDataType;
            baseDataType = baseArray.getDataType();
        }
        return baseDataType;
    }

    private String buildBodyHTML() {
        StringBuffer buffy = new StringBuffer();
        DataType baseDataType = this.getBaseDataType();
        buffy.append("Array Base Data Type: ").append("<BR>");
        buffy.append("<P STYLE='margin-left: 10px;'>");
        if (baseDataType instanceof BuiltInDataType) {
            String simpleName = baseDataType.getClass().getSimpleName();
            buffy.append(simpleName);
            ArrayDataTypeHTMLRepresentation.addDataTypeLength(baseDataType, buffy);
        } else {
            HTMLDataTypeRepresentation representation = ToolTipUtils.getHTMLRepresentation(baseDataType);
            String baseHTML = representation.getHTMLContentString();
            buffy.append(baseHTML);
            if (baseHTML.indexOf("Length: ") < 0) {
                ArrayDataTypeHTMLRepresentation.addDataTypeLength(baseDataType, buffy);
            }
        }
        buffy.append("</P>");
        return buffy.toString();
    }

    private ValidatableLine buildHeaderContent() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("&#47;").append("&#47;").append("&nbsp;");
        Object description = "Array of ";
        Array baseDataType = this.array;
        while (baseDataType instanceof Array) {
            Array baseArray = baseDataType;
            description = (String)description + baseArray.getNumElements() + " elements of ";
            baseDataType = baseArray.getDataType();
        }
        description = (String)description + HTMLUtilities.friendlyEncodeHTML((String)baseDataType.getName());
        buffy.append((String)description);
        return new TextLine(buffy.toString());
    }

    private ValidatableLine buildFooterContent() {
        return new TextLine("Size: " + this.array.getLength());
    }

    private String buildHTMLText(ValidatableLine header, String body, ValidatableLine footer) {
        StringBuffer buffy = new StringBuffer();
        TextLine headerLine = (TextLine)header;
        String headerText = header.getText();
        headerText = ArrayDataTypeHTMLRepresentation.wrapStringInColor(headerText, headerLine.getTextColor());
        buffy.append(headerText);
        buffy.append("<BR>").append("<BR>");
        buffy.append(body);
        buffy.append("<BR>");
        TextLine footerLine = (TextLine)footer;
        String footerText = footer.getText();
        footerText = ArrayDataTypeHTMLRepresentation.wrapStringInColor(footerText, footerLine.getTextColor());
        buffy.append(footerText);
        return buffy.toString();
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof ArrayDataTypeHTMLRepresentation)) {
            return this.completelyDifferentDiff(otherRepresentation);
        }
        ArrayDataTypeHTMLRepresentation other = (ArrayDataTypeHTMLRepresentation)otherRepresentation;
        ValidatableLine header = this.headerContent.copy();
        ValidatableLine footer = this.footerContent.copy();
        String body = this.bodyHtml;
        String otherBody = other.bodyHtml;
        Array otherArray = other.array;
        if (!this.array.isEquivalent((DataType)otherArray)) {
            body = ArrayDataTypeHTMLRepresentation.wrapStringInColorUsingDiv(body, DIFF_COLOR);
            otherBody = ArrayDataTypeHTMLRepresentation.wrapStringInColorUsingDiv(otherBody, DIFF_COLOR);
        }
        ValidatableLine otherHeader = other.headerContent.copy();
        ValidatableLine otherFooter = other.footerContent.copy();
        DataTypeDiff headerDiff = DataTypeDiffBuilder.diffHeader(this.getDiffInput(header), this.getDiffInput(otherHeader));
        DataTypeDiff footerDiff = DataTypeDiffBuilder.diffLines(this.getDiffInput(footer), this.getDiffInput(otherFooter));
        return new HTMLDataTypeRepresentation[]{new ArrayDataTypeHTMLRepresentation(this.array, (ValidatableLine)headerDiff.getLeftLines().get(0), body, (ValidatableLine)footerDiff.getLeftLines().get(0)), new ArrayDataTypeHTMLRepresentation(other.array, (ValidatableLine)headerDiff.getRightLines().get(0), otherBody, (ValidatableLine)footerDiff.getRightLines().get(0))};
    }

    protected static String wrapStringInColorUsingDiv(String string, Color color) {
        if (color == null) {
            return string;
        }
        String rgb = HTMLUtilities.toHexString((Color)color);
        return "<DIV STYLE='color: " + rgb + ";'>" + string + "</DIV>";
    }
}

