/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.C;

import ghidra.app.util.cparser.C.Declaration;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;

public class CompositeHandler {
    private DataType lastBitFieldType = null;
    private int bitLength = 0;
    private int anonCnt = 0;
    private Composite parent;
    private Composite bitFieldUnion;

    public CompositeHandler(Composite parent) {
        this.parent = parent;
    }

    public Composite getComposite() {
        return this.parent;
    }

    public void add(Declaration dec) {
        if (dec == null || dec.getDataType() == null) {
            return;
        }
        if (this.parent instanceof Structure) {
            ((Structure)this.parent).clearFlexibleArrayComponent();
        }
        if (!dec.isBitField()) {
            this.initialize();
            if (dec.isFlexArray() && this.parent instanceof Structure) {
                ((Structure)this.parent).setFlexibleArrayComponent(dec.getDataType(), dec.getName(), dec.getComment());
                return;
            }
            this.parent.add(dec.getDataType(), dec.getName(), dec.getComment());
            return;
        }
        DataType dataType = dec.getDataType();
        int bitSize = dec.getBitFieldSize();
        this.handleFullBitfieldUnion(dataType, bitSize);
        String bitoff = bitSize == 1 ? "" + this.bitLength : this.bitLength + "-" + (this.bitLength + bitSize - 1);
        this.bitFieldUnion.add(dataType, dec.getName(), ": bits " + bitoff);
        this.lastBitFieldType = dataType;
        this.bitLength += bitSize;
    }

    private void handleFullBitfieldUnion(DataType dataType, int bitSize) {
        if (!this.bitfieldFull(dataType, bitSize)) {
            return;
        }
        this.bitFieldUnion = new UnionDataType(this.parent.getCategoryPath(), "anon_" + this.parent.getName() + "_bitfield_" + ++this.anonCnt);
        this.bitFieldUnion = (Composite)this.parent.add((DataType)this.bitFieldUnion).getDataType();
        this.bitLength = 0;
    }

    private boolean bitfieldFull(DataType dataType, int bitSize) {
        if (this.parent instanceof Union) {
            this.bitFieldUnion = this.parent;
            return false;
        }
        if (this.bitFieldUnion == null) {
            return true;
        }
        if (!dataType.equals(this.lastBitFieldType)) {
            return true;
        }
        return this.bitLength + bitSize > dataType.getLength() * 8;
    }

    private void initialize() {
        this.lastBitFieldType = null;
        this.bitLength = 0;
        this.bitFieldUnion = null;
    }
}

