/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigStandAloneMethod
extends CliAbstractSig {
    private CliAbstractSig.CliRetType retType;
    private CliAbstractSig.CliParam[] params;
    private int sizeOfCount;
    private int sentinelIndex = -1;

    public CliSigStandAloneMethod(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = this.getContentsReader();
        byte firstByte = reader.readNextByte();
        long origIndex = reader.getPointerIndex();
        int paramCount = CliSigStandAloneMethod.decodeCompressedUnsignedInt(reader);
        this.sizeOfCount = (int)(reader.getPointerIndex() - origIndex);
        try {
            this.retType = new CliAbstractSig.CliRetType(reader);
        }
        catch (InvalidInputException e) {
            this.retType = null;
        }
        this.params = new CliAbstractSig.CliParam[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            if (reader.peekNextByte() == CliAbstractSig.CliElementType.ELEMENT_TYPE_SENTINAL.id()) {
                reader.readNextByte();
                this.sentinelIndex = i;
            }
            try {
                this.params[i] = new CliAbstractSig.CliParam(reader);
                continue;
            }
            catch (InvalidInputException e) {
                this.params[i] = null;
            }
        }
    }

    @Override
    public String getContentsName() {
        return "StandAloneMethodSig";
    }

    @Override
    public String getContentsComment() {
        return "Typically for calli instruction; Type info for method return and params";
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "FirstByte", "ORed VARARG/DEFAULT/C/STDCALL/THISCALL/FASTCALL and HASTHIS/EXPLICITTHIS");
        struct.add(CliSigStandAloneMethod.getDataTypeForBytes(this.sizeOfCount), "Count", "Number of param types to follow RetType");
        struct.add(this.retType.getDefinitionDataType(), "RetType", null);
        for (CliAbstractSig.CliParam param : this.params) {
            struct.add(param.getDefinitionDataType(), null, null);
        }
        return struct;
    }

    public CliAbstractSig.CliRetType getReturnType() {
        return this.retType;
    }

    public CliAbstractSig.CliParam[] getParams() {
        return (CliAbstractSig.CliParam[])this.params.clone();
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        Object rep = this.getRepresentationOf(this.retType, stream, isShort) + " fn(";
        for (CliAbstractSig.CliParam param : this.params) {
            rep = param == null ? (String)rep + "unidentified_param_type, " : (String)rep + this.getRepresentationOf(param, stream, isShort) + ", ";
        }
        if (this.params.length > 0) {
            rep = ((String)rep).substring(0, ((String)rep).length() - 2);
        }
        rep = (String)rep + ")";
        return rep;
    }
}

