/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import generic.continues.GenericFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.bin.format.pe.InvalidNTHeaderException;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.RichHeader;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.NotYetImplementedException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PortableExecutable {
    public static final String NAME = "PORTABLE_EXECUTABLE";
    public static boolean DEBUG = false;
    private FactoryBundledWithBinaryReader reader;
    private DOSHeader dosHeader;
    private RichHeader richHeader;
    private NTHeader ntHeader;

    public static PortableExecutable createPortableExecutable(GenericFactory factory, ByteProvider bp, SectionLayout layout) throws IOException {
        return PortableExecutable.createPortableExecutable(factory, bp, layout, true, false);
    }

    public static PortableExecutable createPortableExecutable(GenericFactory factory, ByteProvider bp, SectionLayout layout, boolean advancedProcess, boolean parseCliHeaders) throws IOException {
        PortableExecutable portableExecutable = (PortableExecutable)factory.create(PortableExecutable.class, new Object[0]);
        portableExecutable.initPortableExecutable(factory, bp, layout, advancedProcess, parseCliHeaders);
        return portableExecutable;
    }

    private void initPortableExecutable(GenericFactory factory, ByteProvider bp, SectionLayout layout, boolean advancedProcess, boolean parseCliHeaders) throws IOException {
        this.reader = new FactoryBundledWithBinaryReader(factory, bp, true);
        this.dosHeader = DOSHeader.createDOSHeader(this.reader);
        if (this.dosHeader.isDosSignature()) {
            this.richHeader = RichHeader.createRichHeader(this.reader);
            if (this.richHeader.getSize() > 0) {
                this.dosHeader.decrementStub(this.richHeader.getOffset());
            }
            try {
                this.ntHeader = NTHeader.createNTHeader(this.reader, this.dosHeader.e_lfanew(), layout, advancedProcess, parseCliHeaders);
            }
            catch (InvalidNTHeaderException e) {
                Msg.debug((Object)this, (Object)"Expected InvalidNTHeaderException, ignoring");
            }
            catch (NotYetImplementedException e) {
                Msg.debug((Object)this, (Object)"Expected NotYetImplementedException, ignoring");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            return;
        }
    }

    public DOSHeader getDOSHeader() {
        return this.dosHeader;
    }

    public RichHeader getRichHeader() {
        return this.richHeader;
    }

    public NTHeader getNTHeader() {
        return this.ntHeader;
    }

    public void writeHeader(RandomAccessFile raf, DataConverter dc) throws IOException {
        raf.seek(0L);
        if (this.dosHeader != null) {
            this.dosHeader.write(raf, dc);
        }
        if (this.richHeader != null) {
            this.richHeader.write(raf, dc);
        }
        if (this.ntHeader != null) {
            this.ntHeader.writeHeader(raf, dc);
        }
    }

    public static int computeAlignment(int value, int alignment) {
        if (value % alignment == 0) {
            return value;
        }
        int a = (value + alignment) / alignment * alignment;
        return a;
    }

    public long getFileLength() {
        if (this.reader != null) {
            try {
                return this.reader.length();
            }
            catch (IOException e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static enum SectionLayout {
        FILE,
        MEMORY;

    }
}

