/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class NList
implements StructConverter {
    private int n_strx;
    private byte n_type;
    private byte n_sect;
    private short n_desc;
    private long n_value;
    private String string;
    private boolean is32bit;

    static NList createNList(FactoryBundledWithBinaryReader reader, boolean is32bit, int stringTableOffset) throws IOException {
        NList nList = (NList)reader.getFactory().create(NList.class, new Object[0]);
        nList.initNList(reader, is32bit, stringTableOffset);
        return nList;
    }

    private void initNList(FactoryBundledWithBinaryReader reader, boolean is32bit, int stringTableOffset) throws IOException {
        this.is32bit = is32bit;
        this.n_strx = reader.readNextInt();
        this.n_type = reader.readNextByte();
        this.n_sect = reader.readNextByte();
        this.n_desc = reader.readNextShort();
        this.n_value = is32bit ? (long)reader.readNextInt() & 0xFFFFFFFFL : reader.readNextLong();
        try {
            this.string = reader.readAsciiString((long)(stringTableOffset + this.n_strx) & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            this.string = "";
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("nlist", 0);
        struct.add(DWORD, "n_strx", null);
        struct.add(BYTE, "n_type", null);
        struct.add(BYTE, "n_sect", null);
        struct.add(WORD, "n_desc", null);
        if (this.is32bit) {
            struct.add(DWORD, "n_value", null);
        } else {
            struct.add(QWORD, "n_value", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public String getString() {
        return this.string;
    }

    public int getStringTableIndex() {
        return this.n_strx;
    }

    public byte getType() {
        return this.n_type;
    }

    public boolean isTypeUndefined() {
        return this.n_sect == 0 && (this.n_type & 0xE) == 0;
    }

    public boolean isTypeAbsolute() {
        return this.n_sect == 0 && (this.n_type & 0xE) == 2;
    }

    public boolean isTypePreboundUndefined() {
        return this.n_sect == 0 && (this.n_type & 0xE) == 12;
    }

    public boolean isSymbolicDebugging() {
        return (this.n_type & 0xE0) != 0;
    }

    public boolean isPrivateExternal() {
        return (this.n_type & 0x10) != 0;
    }

    public boolean isExternal() {
        return (this.n_type & 1) != 0;
    }

    public boolean isLazyBind() {
        return (this.n_desc & 7) != 0;
    }

    public boolean isThumbSymbol() {
        return (this.n_desc & 8) != 0;
    }

    public byte getSection() {
        return this.n_sect;
    }

    public short getDescription() {
        return this.n_desc;
    }

    public long getValue() {
        return this.n_value;
    }

    public int getLibraryOrdinal() {
        return this.n_desc >> 8 & 0xFF;
    }

    public String toString() {
        return this.string;
    }
}

