/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next.sectionprovider;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import java.io.IOException;

public class BaseSectionProvider
implements DWARFSectionProvider {
    private Program program;

    public static BaseSectionProvider createSectionProviderFor(Program program) {
        return new BaseSectionProvider(program);
    }

    public BaseSectionProvider(Program program) {
        this.program = program;
    }

    @Override
    public ByteProvider getSectionAsByteProvider(String sectionName) throws IOException {
        MemoryBlock block = this.program.getMemory().getBlock(sectionName);
        if (block == null) {
            block = this.program.getMemory().getBlock("." + sectionName);
        }
        if (block != null) {
            return new MemoryByteProvider(this.program.getMemory(), block.getStart());
        }
        return null;
    }

    @Override
    public boolean hasSection(String ... sectionNames) {
        for (String sectionName : sectionNames) {
            if (this.program.getMemory().getBlock(sectionName) != null || this.program.getMemory().getBlock("." + sectionName) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
    }
}

