/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.textfield.IntegerTextField;
import ghidra.app.util.AddressFactoryService;
import ghidra.app.util.AddressInput;
import ghidra.app.util.HexLong;
import ghidra.app.util.ImporterDocumentListener;
import ghidra.app.util.Option;
import ghidra.app.util.opinion.LibraryPathsDialog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.TwoColumnPairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.collections4.map.LazyMap;

public class OptionsEditorPanel
extends JPanel {
    private static final int MAX_PER_COLUMN = 10;
    private static final int MAX_BOOLEANS_WITH_SELECT_ALL = 5;
    private int columns;
    private AddressFactoryService addressFactoryService;

    public OptionsEditorPanel(List<Option> options, AddressFactoryService addressFactoryService) {
        super((LayoutManager)new VerticalLayout(5));
        this.addressFactoryService = addressFactoryService;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.columns = options.size() > 10 ? 2 : 1;
        Map<String, List<Option>> optionGroupMap = this.organizeByGroup(options);
        for (List<Option> optionGroup : optionGroupMap.values()) {
            this.add(this.buildOptionGroupPanel(optionGroup));
        }
    }

    private Component buildOptionGroupPanel(List<Option> optionGroup) {
        JPanel panel = new JPanel(this.getBestLayout());
        String group = optionGroup.get(0).getGroup();
        panel.setBorder(this.createBorder(group));
        for (Option option : optionGroup) {
            panel.add(new JLabel(option.getName(), 4));
            Component editorComponent = this.getEditorComponent(option);
            editorComponent.setName(option.getName());
            panel.add(editorComponent);
        }
        if (this.needsSelectAllDeselectAllButton(optionGroup)) {
            JPanel wrapperPanel = new JPanel(new BorderLayout());
            wrapperPanel.add((Component)panel, "Center");
            List<JCheckBox> list = this.findAllCheckBoxes(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
            buttonPanel.add(this.buildSelectAll(list));
            buttonPanel.add(this.buildDeselectAll(list));
            wrapperPanel.add((Component)buttonPanel, "South");
            Border etchedBorder = BorderFactory.createEtchedBorder(1);
            Border marginBorder = BorderFactory.createEmptyBorder(10, 0, 10, 10);
            panel.setBorder(BorderFactory.createCompoundBorder(etchedBorder, marginBorder));
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
            return wrapperPanel;
        }
        return panel;
    }

    private LayoutManager getBestLayout() {
        if (this.columns == 2) {
            return new TwoColumnPairLayout(4, 50, 4, 0);
        }
        return new PairLayout(4, 4);
    }

    private Component buildSelectAll(List<JCheckBox> list) {
        JPanel panel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Select All");
        button.addActionListener(e -> {
            for (JCheckBox jCheckBox : list) {
                jCheckBox.setSelected(true);
            }
        });
        panel.add(button);
        return panel;
    }

    private Component buildDeselectAll(List<JCheckBox> list) {
        JPanel panel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Deselect All");
        button.addActionListener(e -> {
            for (JCheckBox jCheckBox : list) {
                jCheckBox.setSelected(false);
            }
        });
        panel.add(button);
        return panel;
    }

    private boolean needsSelectAllDeselectAllButton(List<Option> optionGroup) {
        int booleanCount = 0;
        for (Option option : optionGroup) {
            if (!Boolean.class.isAssignableFrom(option.getValueClass())) continue;
            ++booleanCount;
        }
        return booleanCount > 5;
    }

    private Border createBorder(String group) {
        if (group != null) {
            return BorderFactory.createTitledBorder(group);
        }
        return BorderFactory.createEmptyBorder(10, 10, 10, 10);
    }

    private Map<String, List<Option>> organizeByGroup(List<Option> options) {
        LazyMap map = LazyMap.lazyMap(new HashMap(), () -> new ArrayList());
        for (Option option : options) {
            String group = option.getGroup();
            List optionGroup = (List)map.get(group);
            optionGroup.add(option);
        }
        return map;
    }

    private List<JCheckBox> findAllCheckBoxes(JPanel panel) {
        ArrayList<JCheckBox> list = new ArrayList<JCheckBox>();
        this.gatherCheckBoxes(panel, list);
        return list;
    }

    private void gatherCheckBoxes(Container container, ArrayList<JCheckBox> list) {
        Component[] comps;
        for (Component element : comps = container.getComponents()) {
            if (element instanceof JCheckBox) {
                list.add((JCheckBox)element);
            }
            if (!(element instanceof Container)) continue;
            Container subContainer = (Container)element;
            this.gatherCheckBoxes(subContainer, list);
        }
    }

    public Component getEditorComponent(Option option) {
        if (option.getName().equals("Load External Libraries")) {
            return this.buildLoadLibraryPathsEditor(option);
        }
        Component customEditorComponent = option.getCustomEditorComponent();
        if (customEditorComponent != null) {
            return customEditorComponent;
        }
        Class<?> optionClass = option.getValueClass();
        if (Address.class.isAssignableFrom(optionClass)) {
            return this.getAddressEditorComponent(option);
        }
        if (Boolean.class.isAssignableFrom(optionClass)) {
            return this.getBooleanEditorComponent(option);
        }
        if (Long.class.isAssignableFrom(optionClass)) {
            return this.getLongEditorComponent(option);
        }
        if (Integer.class.isAssignableFrom(optionClass)) {
            return this.getIntegerEditorComponent(option);
        }
        if (HexLong.class.isAssignableFrom(optionClass)) {
            return this.getHexLongEditorComponent(option);
        }
        if (String.class.isAssignableFrom(optionClass)) {
            return this.getStringEditorComponent(option);
        }
        if (AddressSpace.class.isAssignableFrom(optionClass)) {
            return this.getAddressSpaceEditorComponent(option);
        }
        throw new AssertException("Attempted to get default editor component for Option type: " + optionClass.getName() + ". Please register a custom editor");
    }

    private Component buildLoadLibraryPathsEditor(Option option) {
        JPanel panel = new JPanel(new BorderLayout());
        JButton button = new JButton("Edit Paths");
        button.addActionListener(e -> DockingWindowManager.showDialog((Component)panel, (DialogComponentProvider)new LibraryPathsDialog()));
        Boolean value = (Boolean)option.getValue();
        boolean initialState = value != null ? value : false;
        JCheckBox jCheckBox = new JCheckBox("", initialState);
        button.setEnabled(initialState);
        jCheckBox.addActionListener(e -> {
            boolean b = jCheckBox.isSelected();
            option.setValue(b);
            button.setEnabled(b);
        });
        panel.add((Component)jCheckBox, "West");
        panel.add((Component)button, "East");
        return panel;
    }

    private Component getAddressSpaceEditorComponent(Option option) {
        AddressSpace[] spaces;
        JComboBox<AddressSpace> combo = new JComboBox<AddressSpace>();
        AddressFactory addressFactory = this.addressFactoryService.getAddressFactory();
        for (AddressSpace space : spaces = addressFactory == null ? new AddressSpace[]{} : addressFactory.getAddressSpaces()) {
            combo.addItem(space);
        }
        AddressSpace space = (AddressSpace)option.getValue();
        if (space != null) {
            combo.setSelectedItem(space);
        }
        return combo;
    }

    private Component getStringEditorComponent(Option option) {
        JTextField tf = new JTextField(5);
        tf.setName(option.getName());
        tf.getDocument().addDocumentListener(new ImporterDocumentListener(option, tf));
        String value = option.getValue() == null ? "" : (String)option.getValue();
        tf.setText(value);
        return tf;
    }

    private Component getHexLongEditorComponent(Option option) {
        IntegerTextField field = new IntegerTextField();
        HexLong hexLong = (HexLong)option.getValue();
        long value = hexLong == null ? 0L : hexLong.longValue();
        field.setValue(value);
        field.setHexMode();
        field.addChangeListener(e -> option.setValue(new HexLong(field.getLongValue())));
        return field.getComponent();
    }

    private Component getIntegerEditorComponent(Option option) {
        IntegerTextField field = new IntegerTextField();
        Integer value = (Integer)option.getValue();
        if (value != null) {
            field.setValue(value.intValue());
        }
        field.addChangeListener(e -> option.setValue(field.getIntValue()));
        return field.getComponent();
    }

    private Component getLongEditorComponent(Option option) {
        IntegerTextField field = new IntegerTextField();
        Long value = (Long)option.getValue();
        field.setValue(value.longValue());
        field.addChangeListener(e -> option.setValue(field.getLongValue()));
        return field.getComponent();
    }

    private Component getBooleanEditorComponent(Option option) {
        JCheckBox cb = new JCheckBox();
        cb.setName(option.getName());
        Boolean b = (Boolean)option.getValue();
        boolean initialState = b != null ? b : false;
        cb.setSelected(initialState);
        cb.addItemListener(e -> option.setValue(cb.isSelected()));
        return cb;
    }

    private Component getAddressEditorComponent(Option option) {
        AddressFactory addressFactory = this.addressFactoryService.getAddressFactory();
        AddressInput addressInput = new AddressInput();
        addressInput.setName(option.getName());
        Address addr = (Address)option.getValue();
        if (addr == null && addressFactory != null) {
            addr = addressFactory.getDefaultAddressSpace().getAddress(0L);
            option.setValue(addr);
        }
        addressInput.setAddressFactory(addressFactory);
        addressInput.setAddress(addr);
        addressInput.addChangeListener(e -> option.setValue(addressInput.getAddress()));
        return addressInput;
    }
}

