/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.propertymanager;

import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.debug.propertymanager.PropertyManagerProvider;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitPropertyChangeRecord;
import ghidra.program.util.ProgramSelection;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.STABLE, packageName="Ghidra Core", category="Testing", shortDescription="Show Markers for Properties", description="This plugin shows a list of properties in the program. For each property selected, navigation markers are displayed to indicate where the property exists.", servicesRequired={MarkerService.class})
public class PropertyManagerPlugin
extends ProgramPlugin
implements DomainObjectListener {
    private static final ImageIcon propIcon = ResourceManager.loadImage((String)"images/searchm_pink.gif");
    static final String DISPLAY_ACTION_NAME = "Display Property Viewer";
    static final String PROPERTY_MARKER_NAME = "Property Locations";
    private PropertyManagerProvider propertyViewProvider = new PropertyManagerProvider(this);
    private MarkerService markerService;
    private MarkerSet searchMarks;
    private Timer updateTimer;

    public PropertyManagerPlugin(PluginTool tool) {
        super(tool, false, true);
    }

    protected void init() {
        this.markerService = (MarkerService)this.tool.getService(MarkerService.class);
        this.updateTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PropertyManagerPlugin.this.propertyViewProvider != null && PropertyManagerPlugin.this.propertyViewProvider.isVisible()) {
                    PropertyManagerPlugin.this.propertyViewProvider.refresh();
                }
            }
        });
        this.updateTimer.setRepeats(false);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (this.propertyViewProvider == null || !this.propertyViewProvider.isVisible()) {
            return;
        }
        boolean affectedByChange = false;
        int cnt = ev.numRecords();
        for (int i = 0; i < cnt; ++i) {
            DomainObjectChangeRecord record = ev.getChangeRecord(i);
            int eventType = record.getEventType();
            if (eventType == 4 || eventType == 23 || eventType == 21 || eventType == 37) {
                affectedByChange = true;
                break;
            }
            if (!(record instanceof CodeUnitPropertyChangeRecord)) continue;
            if (this.currentSelection == null || this.currentSelection.isEmpty()) {
                affectedByChange = true;
                break;
            }
            CodeUnitPropertyChangeRecord pcr = (CodeUnitPropertyChangeRecord)record;
            Address addr = pcr.getAddress();
            if (addr != null) {
                if (!this.currentSelection.contains(addr)) continue;
                affectedByChange = true;
                break;
            }
            addr = pcr.getStartAddress();
            Address endAddr = pcr.getEndAddress();
            if (addr == null || endAddr == null || !this.currentSelection.intersects(addr, endAddr)) continue;
            affectedByChange = true;
            break;
        }
        if (affectedByChange) {
            this.updateTimer.restart();
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.propertyViewProvider.programActivated(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        this.disposeSearchMarks(program);
        if (program != null) {
            program.removeListener((DomainObjectListener)this);
        }
        this.propertyViewProvider.programDeactivated();
    }

    @Override
    protected void selectionChanged(ProgramSelection sel) {
        if (this.propertyViewProvider != null && this.propertyViewProvider.isVisible()) {
            this.updateTimer.restart();
        }
    }

    MarkerSet getSearchMarks() {
        if (this.searchMarks == null && this.currentProgram != null) {
            this.searchMarks = this.markerService.createPointMarker(PROPERTY_MARKER_NAME, "Locations where properties are set", this.currentProgram, 75, true, true, false, Color.pink, propIcon);
        }
        return this.searchMarks;
    }

    void disposeSearchMarks() {
        this.disposeSearchMarks(this.currentProgram);
    }

    private void disposeSearchMarks(Program program) {
        if (this.searchMarks != null && program != null) {
            this.markerService.removeMarker(this.searchMarks, program);
            this.searchMarks = null;
        }
    }

    void clearSearchMarks() {
        if (this.searchMarks != null) {
            this.searchMarks.clearAll();
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeSearchMarks();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        if (this.propertyViewProvider != null) {
            this.propertyViewProvider.dispose();
            this.propertyViewProvider = null;
        }
    }

    PropertyManagerProvider getPropertyViewProvider() {
        return this.propertyViewProvider;
    }

    AddressSetView getCurrentSelection() {
        return this.currentSelection;
    }
}

