/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingActionIf;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.support.GTreeNodeTransferable;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.tasks.GTreeBulkTask;
import ghidra.app.plugin.core.symboltree.SymbolGTree;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.actions.CreateClassAction;
import ghidra.app.plugin.core.symboltree.actions.CreateExternalLocationAction;
import ghidra.app.plugin.core.symboltree.actions.CreateLibraryAction;
import ghidra.app.plugin.core.symboltree.actions.CreateNamespaceAction;
import ghidra.app.plugin.core.symboltree.actions.CutAction;
import ghidra.app.plugin.core.symboltree.actions.DeleteAction;
import ghidra.app.plugin.core.symboltree.actions.EditExternalLocationAction;
import ghidra.app.plugin.core.symboltree.actions.GoToExternalLocationAction;
import ghidra.app.plugin.core.symboltree.actions.GoToToggleAction;
import ghidra.app.plugin.core.symboltree.actions.PasteAction;
import ghidra.app.plugin.core.symboltree.actions.RenameAction;
import ghidra.app.plugin.core.symboltree.actions.SelectionAction;
import ghidra.app.plugin.core.symboltree.actions.SetExternalProgramAction;
import ghidra.app.plugin.core.symboltree.actions.ShowSymbolReferencesAction;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeRootNode;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;

public class SymbolTreeProvider
extends ComponentProviderAdapter {
    private static final String NAME = "Symbol Tree";
    private ClipboardOwner clipboardOwner;
    private Clipboard localClipboard;
    private DomainObjectListener domainObjectListener;
    private Program program;
    private final SymbolTreePlugin plugin;
    private SymbolGTree tree;
    private JPanel mainPanel;
    private JComponent component;
    private GoToToggleAction goToToggleAction;
    private List<GTreeTask> bufferedTasks = new ArrayList<GTreeTask>();
    private SwingUpdateManager domainChangeUpdateManager = new SwingUpdateManager(1000, 30000, "Symbol Tree Provider", () -> {
        if (this.bufferedTasks.isEmpty()) {
            return;
        }
        if (this.bufferedTasks.size() == 1) {
            this.tree.runTask(this.bufferedTasks.remove(0));
            return;
        }
        ArrayList<GTreeTask> copiedTasks = new ArrayList<GTreeTask>(this.bufferedTasks);
        this.bufferedTasks.clear();
        this.tree.runTask((GTreeTask)new BulkWorkTask(this.tree, copiedTasks));
    });
    private Map<Program, GTreeState> treeStateMap = new HashMap<Program, GTreeState>();

    public SymbolTreeProvider(PluginTool tool, SymbolTreePlugin plugin) {
        super(tool, NAME, plugin.getName());
        this.plugin = plugin;
        this.domainObjectListener = new SymbolTreeProviderDomainObjectListener();
        this.localClipboard = new Clipboard(NAME);
        this.component = this.buildProvider();
        plugin.getTool().addComponentProvider((ComponentProvider)this, false);
        this.createActions();
        this.setHelpLocation(new HelpLocation("SymbolTreePlugin", "Symbol_Tree"));
    }

    private JComponent buildProvider() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.tree = this.createTree(new SymbolTreeRootNode());
        this.mainPanel.add((Component)((Object)this.tree), "Center");
        this.tree.setRootVisible(false);
        return this.mainPanel;
    }

    private SymbolGTree createTree(SymbolTreeRootNode rootNode) {
        if (this.tree != null) {
            GTreeRootNode oldRootNode = this.tree.getRootNode();
            this.tree.setProgram(rootNode.getProgram());
            this.tree.setRootNode(rootNode);
            oldRootNode.removeAll();
            return this.tree;
        }
        SymbolGTree newTree = new SymbolGTree(rootNode, this.plugin);
        newTree.addGTreeSelectionListener(e -> {
            GTreeSelectionEvent.EventOrigin origin = e.getEventOrigin();
            if (origin != GTreeSelectionEvent.EventOrigin.USER_GENERATED) {
                return;
            }
            TreePath[] paths = this.tree.getSelectionPaths();
            Object object = paths[0].getLastPathComponent();
            if (!(object instanceof SymbolNode)) {
                this.contextChanged();
                return;
            }
            SymbolNode node = (SymbolNode)object;
            Symbol symbol = node.getSymbol();
            SymbolType type = symbol.getSymbolType();
            if (!type.isNamespace() || type == SymbolType.FUNCTION) {
                this.plugin.goTo(symbol);
            }
            this.contextChanged();
        });
        newTree.setEditable(true);
        return newTree;
    }

    private void createActions() {
        CreateLibraryAction createImportAction = new CreateLibraryAction(this.plugin);
        SetExternalProgramAction setExternalProgramAction = new SetExternalProgramAction(this.plugin, this);
        CreateExternalLocationAction createExternalLocationAction = new CreateExternalLocationAction(this.plugin);
        EditExternalLocationAction editExternalLocationAction = new EditExternalLocationAction(this.plugin);
        CreateClassAction createClassAction = new CreateClassAction(this.plugin);
        CreateNamespaceAction createNamespaceAction = new CreateNamespaceAction(this.plugin);
        RenameAction renameAction = new RenameAction(this.plugin);
        CutAction cutAction = new CutAction(this.plugin, this);
        PasteAction pasteAction = new PasteAction(this.plugin, this);
        DeleteAction deleteAction = new DeleteAction(this.plugin);
        deleteAction.setEnabled(false);
        ShowSymbolReferencesAction referencesAction = new ShowSymbolReferencesAction(this.plugin.getTool(), this.plugin.getName());
        SelectionAction selectionAction = new SelectionAction(this.plugin);
        selectionAction.setEnabled(false);
        this.goToToggleAction = new GoToToggleAction(this.plugin);
        GoToExternalLocationAction goToExternalAction = new GoToExternalLocationAction(this.plugin);
        goToExternalAction.setEnabled(false);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)createImportAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)setExternalProgramAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)createExternalLocationAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)editExternalLocationAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)createClassAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)createNamespaceAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)renameAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)cutAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)pasteAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)deleteAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)referencesAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.goToToggleAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)selectionAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)goToExternalAction);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.program == null) {
            return null;
        }
        return new SymbolTreeActionContext(this, this.program, this.tree, this.tree.getSelectionPaths());
    }

    public void componentShown() {
        this.setProgram(this.program);
    }

    public ImageIcon getIcon() {
        return SymbolTreePlugin.SYMBOL_TREE_ICON;
    }

    void programActivated(Program openedProgram) {
        this.program = openedProgram;
        if (this.tool.isVisible((ComponentProvider)this)) {
            this.setProgram(openedProgram);
        }
    }

    private void setProgram(Program program) {
        if (program == null) {
            return;
        }
        program.addListener(this.domainObjectListener);
        this.mainPanel.remove((Component)((Object)this.tree));
        this.tree = this.createTree(new SymbolTreeRootNode(program));
        this.mainPanel.add((Component)((Object)this.tree));
        this.component.validate();
        GTreeState treeState = this.treeStateMap.get(program);
        if (treeState != null) {
            this.tree.restoreTreeState(treeState);
        }
    }

    void programDeactivated(Program deactivatedProgram) {
        this.tree.cancelWork();
        deactivatedProgram.removeListener(this.domainObjectListener);
        GTreeState treeState = this.tree.getTreeState();
        this.treeStateMap.put(this.program, treeState);
        this.mainPanel.remove((Component)((Object)this.tree));
        this.tree = this.createTree(new SymbolTreeRootNode());
        this.mainPanel.add((Component)((Object)this.tree));
        this.component.validate();
        this.program = null;
    }

    void programClosed(Program closedProgram) {
        this.treeStateMap.remove(closedProgram);
    }

    public void setClipboardContents(GTreeNodeTransferable symbolTreeNodeTransferable) {
        this.localClipboard.setContents((Transferable)symbolTreeNodeTransferable, this.clipboardOwner);
    }

    public Clipboard getClipboard() {
        return this.localClipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reparentSymbols(Namespace namespace, List<Symbol> symbolList) {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        int transactionID = this.program.startTransaction("Change Parent Namespaces");
        try {
            for (Symbol symbol : symbolList) {
                if (!this.canReparentSymbol(symbol) || !this.canMoveSymbol(namespace, symbol)) continue;
                try {
                    symbol.setNamespace(namespace);
                    ++count;
                }
                catch (DuplicateNameException e) {
                    sb.append("Parent namespace " + namespace.getName() + " contains namespace named " + symbol.getName() + "\n");
                }
                catch (InvalidInputException e) {
                    sb.append("Could not change parent namespace for " + symbol.getName() + ": " + e.getMessage() + "\n");
                }
                catch (CircularDependencyException e) {
                    sb.append("Could not change parent namespace for " + symbol.getName() + ": " + e.getMessage() + "\n");
                }
            }
        }
        finally {
            this.program.endTransaction(transactionID, true);
        }
        if (sb.length() > 0) {
            Msg.showInfo(((Object)((Object)this)).getClass(), null, (String)"Change Parent Namespace Failed", (Object)sb.toString());
        }
        return count;
    }

    private boolean canMoveSymbol(Namespace destinationNamespace, Symbol symbol) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        if (symbol.isDescendant(destinationNamespace)) {
            return false;
        }
        if (!symbol.isValidParent(destinationNamespace)) {
            return false;
        }
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType.allowsDuplicates()) {
            return true;
        }
        List symbols = symbolTable.getSymbols(symbol.getName(), destinationNamespace);
        for (Symbol s : symbols) {
            if (s.getSymbolType().allowsDuplicates()) continue;
            return false;
        }
        return true;
    }

    private boolean canReparentSymbol(Symbol symbol) {
        SymbolType symbolType = symbol.getSymbolType();
        return symbolType == SymbolType.CODE || symbolType == SymbolType.FUNCTION || symbolType == SymbolType.NAMESPACE || symbolType == SymbolType.CLASS;
    }

    private void rebuildTree() {
        GTreeRootNode node = this.tree.getRootNode();
        node.removeAll();
    }

    private void symbolChanged(Symbol symbol, String oldName) {
        this.addTask(new SymbolChangedTask(this.tree, symbol, oldName));
    }

    private void symbolChanged(Symbol symbol) {
        this.addTask(new SymbolChangedTask(this.tree, symbol));
    }

    private void symbolAdded(Symbol symbol) {
        this.addTask(new SymbolAddedTask(this.tree, symbol));
    }

    private void symbolRemoved(Symbol symbol) {
        this.addTask(new SymbolRemovedTask(this.tree, symbol));
    }

    private void addTask(GTreeTask task) {
        SystemUtilities.assertThisIsTheSwingThread((String)"Adding tasks must be done on the Swing thread,since they are put into a list that is processed on the Swing thread. ");
        this.bufferedTasks.add(task);
        this.domainChangeUpdateManager.update();
    }

    void showComponent(Program currentProgram) {
        if (!this.tool.isVisible((ComponentProvider)this)) {
            this.setProgram(currentProgram);
        }
        this.tool.showComponentProvider((ComponentProvider)this, true);
    }

    public void locationChanged(ProgramLocation loc) {
        if (!this.goToToggleAction.isSelected()) {
            return;
        }
        Symbol symbol = null;
        Address addr = loc.getAddress();
        if (loc instanceof VariableLocation) {
            Variable var = ((VariableLocation)loc).getVariable();
            if (var == null) {
                return;
            }
            symbol = var.getSymbol();
        } else if (loc instanceof FunctionSignatureFieldLocation || loc instanceof FunctionReturnTypeFieldLocation) {
            Function function = this.program.getFunctionManager().getFunctionContaining(addr);
            if (function == null) {
                return;
            }
            symbol = function.getSymbol();
        } else if (loc instanceof OperandFieldLocation) {
            Reference[] refs;
            int opIndex = ((OperandFieldLocation)loc).getOperandIndex();
            CodeUnit cu = this.program.getListing().getCodeUnitContaining(addr);
            for (Reference element : refs = cu.getOperandReferences(opIndex)) {
                symbol = this.program.getSymbolTable().getSymbol(element);
                if (symbol == null) {
                    continue;
                }
                break;
            }
        } else if (loc instanceof LabelFieldLocation) {
            LabelFieldLocation lfLoc = (LabelFieldLocation)loc;
            symbol = lfLoc.getSymbol();
        } else {
            symbol = this.program.getSymbolTable().getPrimarySymbol(loc.getAddress());
        }
        if (symbol == null || symbol.isDynamic()) {
            return;
        }
        GTreeRootNode node = this.tree.getRootNode();
        SymbolTreeRootNode rootNode = (SymbolTreeRootNode)node;
        this.tree.runTask(new SearchTask(this.tree, rootNode, symbol));
    }

    void readConfigState(SaveState saveState) {
        this.goToToggleAction.setSelected(saveState.getBoolean("GO_TO_TOGGLE_STATE", false));
    }

    void writeConfigState(SaveState saveState) {
        saveState.putBoolean("GO_TO_TOGGLE_STATE", this.goToToggleAction.isSelected());
    }

    void dispose() {
        this.domainChangeUpdateManager.dispose();
        this.bufferedTasks.clear();
        this.tree.dispose();
        this.treeStateMap.clear();
        this.tree = null;
        this.mainPanel.removeAll();
        if (this.program != null) {
            this.program.removeListener(this.domainObjectListener);
            this.program = null;
        }
    }

    private class SymbolTreeProviderDomainObjectListener
    implements DomainObjectListener {
        private SymbolTreeProviderDomainObjectListener() {
        }

        public void domainObjectChanged(DomainObjectChangedEvent event) {
            if (!SymbolTreeProvider.this.tool.isVisible((ComponentProvider)SymbolTreeProvider.this)) {
                return;
            }
            if (event.containsEvent(4)) {
                SymbolTreeProvider.this.rebuildTree();
                return;
            }
            int recordCount = event.numRecords();
            for (int i = 0; i < recordCount; ++i) {
                Symbol[] symbols;
                Symbol symbol;
                DomainObjectChangeRecord rec = event.getChangeRecord(i);
                int eventType = rec.getEventType();
                Object object = null;
                if (rec instanceof ProgramChangeRecord) {
                    object = ((ProgramChangeRecord)rec).getObject();
                }
                if (eventType == 46) {
                    symbol = (Symbol)object;
                    String oldName = (String)rec.getOldValue();
                    SymbolTreeProvider.this.symbolChanged(symbol, oldName);
                    continue;
                }
                if (eventType == 52 || eventType == 49 || eventType == 152) {
                    symbol = null;
                    if (object instanceof Symbol) {
                        symbol = (Symbol)object;
                    } else if (object instanceof Namespace) {
                        symbol = ((Namespace)object).getSymbol();
                    }
                    SymbolTreeProvider.this.symbolChanged(symbol);
                    continue;
                }
                if (eventType == 40) {
                    symbol = (Symbol)rec.getNewValue();
                    SymbolTreeProvider.this.symbolAdded(symbol);
                    continue;
                }
                if (eventType == 41) {
                    symbol = (Symbol)object;
                    SymbolTreeProvider.this.symbolRemoved(symbol);
                    continue;
                }
                if (eventType != 47 && eventType != 48) continue;
                ProgramChangeRecord programChangeRecord = (ProgramChangeRecord)rec;
                Address address = programChangeRecord.getStart();
                SymbolTable symbolTable = SymbolTreeProvider.this.program.getSymbolTable();
                for (Symbol symbol2 : symbols = symbolTable.getSymbols(address)) {
                    SymbolTreeProvider.this.symbolChanged(symbol2);
                }
            }
        }
    }

    private class BulkWorkTask
    extends GTreeBulkTask {
        private static final int MAX_TASK_COUNT = 1000;
        private List<GTreeTask> tasks;

        BulkWorkTask(GTree gTree, List<GTreeTask> tasks) {
            super(gTree);
            this.tasks = tasks;
        }

        public void runBulk(TaskMonitor monitor) throws CancelledException {
            if (this.tasks.size() > 1000) {
                SystemUtilities.runSwingLater(() -> SymbolTreeProvider.this.rebuildTree());
                return;
            }
            for (GTreeTask task : this.tasks) {
                monitor.checkCanceled();
                task.run(monitor);
            }
        }
    }

    private class SymbolRemovedTask
    extends AbstactSymbolUpdateTask {
        SymbolRemovedTask(GTree tree, Symbol symbol) {
            super(tree, symbol);
        }

        @Override
        void doRun(TaskMonitor monitor) throws CancelledException {
            GTreeRootNode node = this.tree.getRootNode();
            SymbolTreeRootNode rootNode = (SymbolTreeRootNode)node;
            rootNode.symbolRemoved(this.symbol, monitor);
        }
    }

    private class SymbolChangedTask
    extends AbstactSymbolUpdateTask {
        private String oldName;

        SymbolChangedTask(GTree tree, Symbol symbol) {
            this(tree, symbol, symbol.getName());
        }

        SymbolChangedTask(GTree tree, Symbol symbol, String oldName) {
            super(tree, symbol);
            this.oldName = Objects.requireNonNull(oldName);
        }

        @Override
        void doRun(TaskMonitor monitor) throws CancelledException {
            GTreeRootNode node = this.tree.getRootNode();
            SymbolTreeRootNode rootNode = (SymbolTreeRootNode)node;
            rootNode.symbolRemoved(this.symbol, this.oldName, monitor);
            if (this.symbol.checkIsValid()) {
                rootNode.symbolAdded(this.symbol);
            }
        }
    }

    private class SymbolAddedTask
    extends AbstactSymbolUpdateTask {
        SymbolAddedTask(GTree tree, Symbol symbol) {
            super(tree, symbol);
        }

        @Override
        void doRun(TaskMonitor monitor) throws CancelledException {
            GTreeRootNode node = this.tree.getRootNode();
            SymbolTreeRootNode rootNode = (SymbolTreeRootNode)node;
            if (this.symbol.checkIsValid()) {
                rootNode.symbolAdded(this.symbol);
            }
        }
    }

    private abstract class AbstactSymbolUpdateTask
    extends GTreeTask {
        protected final Symbol symbol;

        AbstactSymbolUpdateTask(GTree tree, Symbol symbol) {
            super(tree);
            this.symbol = symbol;
        }

        abstract void doRun(TaskMonitor var1) throws CancelledException;

        public void run(TaskMonitor monitor) throws CancelledException {
            TreePath[] selectionPaths = this.tree.getSelectionPaths();
            this.doRun(monitor);
            this.tree.setSelectionPaths(selectionPaths);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.symbol;
        }
    }

    private class SearchTask
    extends GTreeTask {
        private SymbolTreeRootNode rootNode;
        private Symbol searchSymbol;

        private SearchTask(GTree tree, SymbolTreeRootNode rootNode, Symbol searchSymbol) {
            super(tree);
            this.rootNode = rootNode;
            this.searchSymbol = searchSymbol;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            monitor.setMessage("Searching for " + this.searchSymbol.getName());
            SymbolNode key = SymbolNode.createNode(this.searchSymbol, SymbolTreeProvider.this.program);
            GTreeNode node = this.rootNode.findSymbolTreeNode(key, true, monitor);
            if (node != null) {
                this.tree.setSelectedNode(node);
            }
        }
    }
}

