/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext.databasesearcher;

import ghidra.app.plugin.core.searchtext.databasesearcher.ProgramDatabaseFieldSearcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstructionMnemonicOperandFieldSearcher
extends ProgramDatabaseFieldSearcher {
    private InstructionIterator iterator;
    private final CodeUnitFormat format;
    private final boolean doMnemonics;
    private final boolean doOperands;
    private Program program;

    public static InstructionMnemonicOperandFieldSearcher createInstructionMnemonicOnlyFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern, CodeUnitFormat format) {
        return new InstructionMnemonicOperandFieldSearcher(program, startLoc, set, forward, pattern, format, true, false);
    }

    public static InstructionMnemonicOperandFieldSearcher createInstructionOperandOnlyFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern, CodeUnitFormat format) {
        return new InstructionMnemonicOperandFieldSearcher(program, startLoc, set, forward, pattern, format, false, true);
    }

    public static InstructionMnemonicOperandFieldSearcher createInstructionMnemonicAndOperandFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern, CodeUnitFormat format) {
        return new InstructionMnemonicOperandFieldSearcher(program, startLoc, set, forward, pattern, format, true, true);
    }

    private InstructionMnemonicOperandFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern, CodeUnitFormat format, boolean doMnemonics, boolean doOperands) {
        super(pattern, forward, startLoc, set);
        this.program = program;
        this.format = format;
        this.doMnemonics = doMnemonics;
        this.doOperands = doOperands;
        this.iterator = set != null ? program.getListing().getInstructions(set, forward) : program.getListing().getInstructions(startLoc.getAddress(), forward);
    }

    @Override
    protected Address advance(List<ProgramLocation> currentMatches) {
        Instruction instruction = this.iterator.next();
        Address nextAddress = null;
        if (instruction != null) {
            nextAddress = instruction.getMinAddress();
            this.findMatchesForCurrentAddress(instruction, currentMatches);
        }
        return nextAddress;
    }

    private void findMatchesForCurrentAddress(Instruction instruction, List<ProgramLocation> currentMatches) {
        String mnemonicString = instruction.getMnemonicString();
        String[] opStrings = this.getOperandStrings(instruction);
        Matcher matcher = this.pattern.matcher(this.combineStrings(mnemonicString, opStrings));
        Address address = instruction.getMinAddress();
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex <= mnemonicString.length()) {
                this.addMnemonicMatch(currentMatches, address, mnemonicString, startIndex, endIndex);
                continue;
            }
            this.addOperandMatch(instruction, currentMatches, opStrings, address, startIndex -= mnemonicString.length() + 1);
        }
    }

    private void addOperandMatch(Instruction instruction, List<ProgramLocation> currentMatches, String[] opStrings, Address address, int index) {
        if (!this.doOperands) {
            return;
        }
        int opIndex = this.findOpIndex(opStrings, index);
        int charOffset = this.findCharOffset(index, opIndex, opStrings);
        currentMatches.add((ProgramLocation)new OperandFieldLocation(this.program, address, null, instruction.getAddress(opIndex), opStrings[opIndex], opIndex, charOffset));
    }

    private void addMnemonicMatch(List<ProgramLocation> currentMatches, Address address, String mnemonicString, int startIndex, int endIndex) {
        if (!this.doMnemonics) {
            return;
        }
        if (!this.doOperands && endIndex > mnemonicString.length()) {
            return;
        }
        currentMatches.add((ProgramLocation)new MnemonicFieldLocation(this.program, address, null, null, mnemonicString, startIndex));
    }

    private int findCharOffset(int index, int opIndex, String[] opStrings) {
        int totalBeforeOpIndex = 0;
        for (int i = 0; i < opIndex; ++i) {
            totalBeforeOpIndex += opStrings[i].length();
        }
        return index - totalBeforeOpIndex;
    }

    private int findOpIndex(String[] opStrings, int index) {
        int totalSoFar = 0;
        for (int i = 0; i < opStrings.length; ++i) {
            if (index < totalSoFar + opStrings[i].length()) {
                return i;
            }
            totalSoFar += opStrings[i].length();
        }
        return opStrings.length - 1;
    }

    private CharSequence combineStrings(String mnemonicString, String[] opStrings) {
        if (opStrings.length == 0) {
            return mnemonicString;
        }
        StringBuffer buf = new StringBuffer(mnemonicString);
        buf.append(' ');
        for (String string : opStrings) {
            buf.append(string);
        }
        return buf.toString();
    }

    private String[] getOperandStrings(Instruction instruction) {
        String separator;
        int nOperands = instruction.getNumOperands();
        String[] opStrings = new String[nOperands];
        for (int i = 0; i < nOperands; ++i) {
            opStrings[i] = this.format.getOperandRepresentationString((CodeUnit)instruction, i);
            if (!instruction.getPrototype().hasDelimeter(i)) continue;
            opStrings[i] = opStrings[i] + instruction.getSeparator(i + 1);
        }
        if (nOperands > 0 && (separator = instruction.getSeparator(0)) != null) {
            opStrings[0] = separator + opStrings[0];
        }
        return opStrings;
    }
}

