/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem;

import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.app.plugin.core.searchmem.SearchFormat;
import ghidra.util.HTMLUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeListener;

public class HexSearchFormat
extends SearchFormat {
    private static final String WILD_CARDS = ".?";
    private static final String HEX_CHARS = "0123456789abcdefABCDEF.?";
    private String statusText;

    public HexSearchFormat(ChangeListener listener) {
        super("Hex", listener);
    }

    @Override
    public String getToolTip() {
        return HTMLUtilities.toHTML((String)"Interpret value as a sequence of\nhex numbers, separated by spaces.\nEnter '*' or '?' for a wildcard match");
    }

    @Override
    public SearchData getSearchData(String input) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(input);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!this.isValidHex(token)) {
                return SearchData.createInvalidInputSearchData(this.statusText);
            }
            List<String> byteList = this.getByteStrings(token);
            if (!this.isBigEndian) {
                Collections.reverse(byteList);
            }
            list.addAll(byteList);
        }
        byte[] bytes = new byte[list.size()];
        byte[] mask = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String byteString = (String)list.get(i);
            bytes[i] = this.getByte(byteString);
            mask[i] = this.getMask(byteString);
        }
        return SearchData.createSearchData(input, bytes, mask);
    }

    private List<String> getByteStrings(String token) {
        if (((String)token).length() % 2 != 0) {
            token = "0" + (String)token;
        }
        int n = ((String)token).length() / 2;
        ArrayList<String> list = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            list.add(((String)token).substring(i * 2, i * 2 + 2));
        }
        return list;
    }

    private boolean isValidHex(String str) {
        if (str.length() > 16) {
            this.statusText = "Max group size exceeded. Enter <space> to add more.";
            return false;
        }
        this.statusText = "";
        for (int i = 0; i < str.length(); ++i) {
            if (HEX_CHARS.indexOf(str.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    private byte getByte(String tok) {
        char c1 = tok.charAt(0);
        char c2 = tok.charAt(1);
        if (WILD_CARDS.indexOf(c1) > 0) {
            c1 = '0';
        }
        if (WILD_CARDS.indexOf(c2) > 0) {
            c2 = '0';
        }
        return (byte)(this.hexValueOf(c1) * 16 + this.hexValueOf(c2));
    }

    private byte getMask(String tok) {
        char c1 = tok.charAt(0);
        char c2 = tok.charAt(1);
        int index1 = WILD_CARDS.indexOf(c1);
        int index2 = WILD_CARDS.indexOf(c2);
        if (index1 >= 0 && index2 >= 0) {
            return 0;
        }
        if (index1 >= 0 && index2 < 0) {
            return 15;
        }
        if (index1 < 0 && index2 >= 0) {
            return -16;
        }
        return -1;
    }

    private int hexValueOf(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }
}

