/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.register.RegisterWrapper;
import ghidra.app.util.bean.FixedBitSizeValueField;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SetRegisterValueDialog
extends DialogComponentProvider {
    private JComboBox registerComboBox;
    private FixedBitSizeValueField registerValueField;
    private JList addressRangeList;
    private BigInteger registerValue;
    private Register selectedRegister;
    private boolean useValueField;
    private final AddressSetView addrSet;
    private final Program program;

    protected SetRegisterValueDialog(Program program, Register[] registers, Register register, AddressSetView addrSet, boolean useValueField) {
        super(useValueField ? "Set" : "Clear Register Values", true, true, true, false);
        this.program = program;
        this.addrSet = addrSet;
        this.useValueField = useValueField;
        this.addWorkPanel(this.buildWorkPanel(registers));
        this.addOKButton();
        this.addCancelButton();
        if (useValueField) {
            this.setFocusComponent(this.registerValueField.getTextComponent());
        }
        this.setSelectedRegister(register);
        this.setAddressRanges(addrSet);
        this.registerChanged();
        this.updateOkEnablement();
        this.setDefaultButton(this.okButton);
        this.setHelpLocation(new HelpLocation("RegisterPlugin", useValueField ? "SetRegisterValues" : "ClearRegisterValues"));
        this.setRememberSize(false);
    }

    private void updateOkEnablement() {
        this.setOkEnabled(!this.useValueField || this.registerValueField.getValue() != null);
    }

    private JComponent buildWorkPanel(Register[] registers) {
        JLabel regLabel = new JLabel("Register:");
        JLabel valueLabel = new JLabel("Value:");
        JLabel addressLabel = new JLabel("Address(es):");
        addressLabel.setVerticalAlignment(1);
        this.registerComboBox = new JComboBox<Object>(this.wrapRegisters(registers));
        Font f = this.registerComboBox.getFont().deriveFont(13.0f);
        this.registerComboBox.setFont(f);
        this.registerValueField = new FixedBitSizeValueField(32, true, false);
        this.registerValueField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SetRegisterValueDialog.this.updateOkEnablement();
            }
        });
        this.registerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SetRegisterValueDialog.this.registerChanged();
            }
        });
        f = new Font("monospaced", 0, 13);
        this.addressRangeList = new JList();
        this.addressRangeList.setEnabled(false);
        this.addressRangeList.setFont(f);
        JScrollPane scrollPane = new JScrollPane(this.addressRangeList);
        scrollPane.setVerticalScrollBarPolicy(22);
        Dimension d = scrollPane.getPreferredSize();
        d.height = 120;
        d.width = 180;
        scrollPane.setPreferredSize(d);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 1, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)regLabel, gbc);
        gbc.gridy = 1;
        if (this.useValueField) {
            panel.add((Component)valueLabel, gbc);
        }
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 5, 1, 5);
        panel.add((Component)addressLabel, gbc);
        gbc.insets = new Insets(5, 5, 1, 5);
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        panel.add((Component)this.registerComboBox, gbc);
        gbc.gridy = 1;
        if (this.useValueField) {
            panel.add((Component)this.registerValueField, gbc);
        }
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)scrollPane, gbc);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        return panel;
    }

    private void registerChanged() {
        RegisterWrapper wrapper = (RegisterWrapper)this.registerComboBox.getSelectedItem();
        if (wrapper != null) {
            this.registerValueField.setBitSize(wrapper.register.getBitLength());
            this.updateOkEnablement();
        }
        this.updateValue();
    }

    void setSelectedRegister(Register register) {
        int n = this.registerComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            RegisterWrapper rw = (RegisterWrapper)this.registerComboBox.getItemAt(i);
            if (rw.register != register) continue;
            this.registerComboBox.setSelectedIndex(i);
            return;
        }
        this.updateValue();
    }

    private void updateValue() {
        if (this.addrSet.getNumAddresses() == 1L) {
            BigInteger unsignedValue;
            Address address = this.addrSet.getMinAddress();
            RegisterValue value = this.program.getProgramContext().getRegisterValue(this.doGetSelectedRegister(), address);
            if (value != null && (unsignedValue = value.getUnsignedValue()) != null) {
                this.registerValueField.setValue(unsignedValue);
                return;
            }
        }
        this.registerValueField.setValue(null);
    }

    Object[] wrapRegisters(Register[] registers) {
        if (registers.length == 0) {
            return registers;
        }
        Object[] registerWrappers = new Object[registers.length];
        for (int i = 0; i < registers.length; ++i) {
            registerWrappers[i] = new RegisterWrapper(registers[i]);
        }
        Arrays.sort(registerWrappers);
        return registerWrappers;
    }

    private void setAddressRanges(AddressSetView addrSet) {
        String[] rangeData = new String[addrSet.getNumAddressRanges()];
        int i = 0;
        for (AddressRange range : addrSet) {
            Address end;
            Address start = range.getMinAddress();
            if (start.equals((Object)(end = range.getMaxAddress()))) {
                rangeData[i++] = start.toString();
                continue;
            }
            rangeData[i++] = start.toString() + " - " + end.toString();
        }
        this.addressRangeList.setListData(rangeData);
    }

    protected void okCallback() {
        this.registerValue = this.registerValueField.getValue();
        this.selectedRegister = this.doGetSelectedRegister();
        this.close();
    }

    public BigInteger getRegisterValue() {
        return this.registerValue;
    }

    private Register doGetSelectedRegister() {
        RegisterWrapper wrapper = (RegisterWrapper)this.registerComboBox.getSelectedItem();
        if (wrapper != null) {
            return wrapper.register;
        }
        return null;
    }

    public Register getSelectRegister() {
        return this.selectedRegister;
    }
}

