/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import ghidra.app.plugin.core.register.RegisterTreeNode;
import ghidra.app.plugin.core.register.RegisterTreeRootNode;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public class RegisterTree
extends GTree {
    private Program program;
    private RegisterTreeRootNode root = (RegisterTreeRootNode)this.getRootNode();
    private boolean isFiltered;

    public RegisterTree() {
        super((GTreeRootNode)new RegisterTreeRootNode());
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setHorizontalScrollPolicy(31);
        JScrollPane scrollPane = this.getScrollPane();
        final JViewport viewport = scrollPane.getViewport();
        scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Point viewPosition = viewport.getViewPosition();
                if (viewPosition.x != 0) {
                    viewPosition.x = 0;
                    viewport.setViewPosition(viewPosition);
                }
            }
        });
        this.setMinimumSize(new Dimension(175, 30));
    }

    void setProgram(Program program) {
        this.cancelWork();
        this.program = program;
        Register[] registers = null;
        registers = program != null ? (this.isFiltered ? program.getProgramContext().getRegistersWithValues() : RegisterTree.getNonHiddenRegisters(program)) : new Register[]{};
        this.root.setRegisters(registers);
    }

    private static Register[] getNonHiddenRegisters(Program program) {
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register reg : program.getProgramContext().getRegisters()) {
            if (reg.isHidden()) continue;
            list.add(reg);
        }
        Collections.sort(list);
        Register[] registers = new Register[list.size()];
        return list.toArray(registers);
    }

    void setFiltered(boolean b) {
        this.isFiltered = b;
        if (this.program != null) {
            Register[] registers = this.isFiltered ? this.program.getProgramContext().getRegistersWithValues() : RegisterTree.getNonHiddenRegisters(this.program);
            this.root.setRegisters(registers);
        }
    }

    public void selectRegister(Register register) {
        GTreeNode node = this.root.findNode(register);
        if (node != null) {
            TreePath path = node.getTreePath();
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    public void updateFilterList() {
        if (this.isFiltered) {
            Register currentRegister = this.getSelectedRegister();
            Register[] registers = this.program.getProgramContext().getRegistersWithValues();
            this.root.setRegisters(registers);
            this.selectRegister(currentRegister);
        }
    }

    Register getSelectedRegister() {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        Object item = selectionPath.getLastPathComponent();
        if (item instanceof RegisterTreeNode) {
            return ((RegisterTreeNode)((Object)item)).getRegister();
        }
        return null;
    }
}

