/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import ghidra.app.cmd.module.ReorderModuleCmd;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import java.awt.Component;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

class ReorderManager {
    private ProgramDnDTree tree;

    ReorderManager(ProgramDnDTree tree) {
        this.tree = tree;
    }

    boolean isDropSiteOk(ProgramNode destNode, ProgramNode dropNode, int dropAction, int relativeMousePos) {
        ProgramModule mParent = destNode.getParentModule();
        Group dragGroup = dropNode.getGroup();
        if (dragGroup.equals(destNode.getGroup())) {
            return false;
        }
        if (mParent == null && relativeMousePos != 0) {
            return false;
        }
        if (destNode.equals(dropNode.getParent())) {
            return dropAction == 2;
        }
        if (dropNode.getParent().equals(destNode.getParent()) && dropAction != 2) {
            return false;
        }
        if (!dropNode.getParent().equals(destNode.getParent())) {
            if (dropNode.isFragment()) {
                ProgramModule dm;
                ProgramFragment frag = dropNode.getFragment();
                if (mParent != null && mParent.contains(frag)) {
                    return false;
                }
                if (mParent == null && destNode.getModule().contains(frag)) {
                    return false;
                }
                return !destNode.isModule() || !(dm = destNode.getModule()).contains(frag);
            }
            ProgramModule m = dropNode.getModule();
            if (mParent != null && !m.equals(mParent) && mParent.contains(m) || m.equals(mParent)) {
                return false;
            }
            if (mParent == null && destNode.getModule().contains(m)) {
                return false;
            }
        }
        if (destNode.isModule() && dropAction == 1) {
            ProgramModule dm = destNode.getModule();
            if (dropNode.isModule() ? dm.contains(dropNode.getModule()) : dm.contains(dropNode.getFragment())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(ProgramNode destNode, ProgramNode[] dropNodes, int dropAction, int relativeMousePos) throws NotFoundException, CircularDependencyException, DuplicateGroupException {
        ProgramModule targetModule = destNode.getModule();
        ProgramFragment targetFrag = destNode.getFragment();
        if (targetModule == null && targetFrag == null) {
            this.tree.clearDragData();
            return;
        }
        int transactionID = this.tree.startTransaction("Reorder");
        if (transactionID < 0) {
            return;
        }
        try {
            for (int i = 0; i < dropNodes.length; ++i) {
                ProgramNode parentNode = (ProgramNode)destNode.getParent();
                this.reorderNode(destNode, dropAction, relativeMousePos, parentNode, dropNodes[i]);
            }
        }
        finally {
            this.tree.endTransaction(transactionID, true);
        }
    }

    private void reorderNode(ProgramNode destNode, int dropAction, int relativeMousePos, ProgramNode parentNode, ProgramNode dropNode) throws NotFoundException, CircularDependencyException, DuplicateGroupException {
        if (!this.reorderChildren(destNode, dropNode, relativeMousePos)) {
            int index;
            if (relativeMousePos < 0) {
                if (parentNode == null) {
                    return;
                }
                index = parentNode.getIndex(destNode);
            } else if (destNode.isModule() && this.tree.isExpanded(destNode.getTreePath())) {
                index = 0;
                destNode = (ProgramNode)destNode.getChildAt(0);
            } else {
                index = parentNode.getIndex(destNode);
                ++index;
            }
            this.addGroup(destNode, dropNode, index, dropAction);
            ProgramNode child = (ProgramNode)parentNode.getChildAt(index);
            this.selectNode(dropNode, child);
        }
    }

    private boolean reorderChildren(ProgramNode destNode, ProgramNode dropNode, int relativeMousePos) {
        boolean didReorder = false;
        int index = 0;
        ProgramNode parentNode = (ProgramNode)destNode.getParent();
        ProgramModule dropParentModule = dropNode.getParentModule();
        ProgramModule targetModule = destNode.getModule();
        if (parentNode.equals(dropNode.getParent())) {
            didReorder = true;
            targetModule = parentNode.getModule();
            int myIndex = parentNode.getIndex(dropNode);
            index = parentNode.getIndex(destNode);
            if (relativeMousePos < 0 && myIndex < index) {
                --index;
            } else if (relativeMousePos > 0 && myIndex > index) {
                ++index;
            }
            Group group = dropNode.getGroup();
            ReorderModuleCmd cmd = new ReorderModuleCmd(this.tree.getTreeName(), targetModule.getName(), group.getName(), index);
            if (this.tree.getTool().execute((Command)cmd, (DomainObject)this.tree.getProgram())) {
                this.tree.reorder(group, dropParentModule, index);
                ProgramNode child = (ProgramNode)parentNode.getChildAt(index);
                this.addToSelection(child);
            } else {
                Msg.showError((Object)this, (Component)this.tree, (String)"Error Moving Child", (Object)cmd.getStatusMsg());
            }
        }
        return didReorder;
    }

    private void selectNode(ProgramNode dropNode, ProgramNode nodeToSelect) {
        this.tree.matchExpansionState(dropNode, nodeToSelect);
        this.addToSelection(nodeToSelect);
    }

    private void addToSelection(ProgramNode node) {
        final TreePath p = node.getTreePath();
        this.tree.addSelectionPath(p);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ReorderManager.this.tree.addSelectionPath(p);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private void addGroup(ProgramNode destNode, ProgramNode dropNode, int targetIndex, int dropAction) throws NotFoundException, CircularDependencyException, DuplicateGroupException {
        Object group = null;
        ProgramNode targetParent = (ProgramNode)destNode.getParent();
        ProgramModule targetParentModule = targetParent != null ? targetParent.getModule() : destNode.getModule();
        ProgramFragment dropFragment = dropNode.getFragment();
        ProgramModule dropModule = dropNode.getModule();
        if (dropAction == 1) {
            if (dropFragment != null) {
                targetParentModule.add(dropFragment);
                group = dropFragment;
            } else {
                targetParentModule.add(dropModule);
                group = dropModule;
            }
        } else {
            targetParentModule.reparent(dropNode.getName(), dropNode.getParentModule());
            group = dropFragment != null ? dropFragment : dropModule;
        }
        this.tree.groupAdded((Group)group);
        targetParentModule.moveChild(group.getName(), targetIndex);
        this.tree.reorder(dropNode.getGroup(), targetParentModule, targetIndex);
    }
}

