/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.entropy;

import ghidra.app.plugin.core.overview.entropy.EntropyChunkSize;
import ghidra.app.plugin.core.overview.entropy.EntropyKnot;
import ghidra.app.plugin.core.overview.entropy.EntropyOverviewColorService;
import ghidra.app.plugin.core.overview.entropy.EntropyRecord;
import ghidra.app.plugin.core.overview.entropy.Palette;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.Color;

public class EntropyOverviewOptionsManager
implements OptionsChangeListener {
    private static final Color uninitializedColor = Color.decode("0x0000ff");
    private static final String OPTIONS_NAME = "Entropy";
    private static final String CHUNKSIZE_STRING = "Chunk size";
    private static final String CHUNKSIZE_DESC_STRING = "Number of bytes per entropy score";
    private static final EntropyChunkSize chunksize_def = EntropyChunkSize.LARGE;
    private static final String KNOT_COLOR_STRING = "Color to use for highlighting a specific range of entropy values";
    private static final String KNOT_TYPE_STRING = "Type of range to highlight";
    private static final String KNOT1_COLOR_STRING = "Range 1 color";
    private static final String KNOT1_TYPE_STRING = "Entropy Range 1";
    private static final Color knot1_def_color = Color.decode("0xff0000");
    private static final EntropyKnot knot1_def_type = EntropyKnot.COMPRESSED;
    private static final String KNOT2_COLOR_STRING = "Range 2 color";
    private static final String KNOT2_TYPE_STRING = "Entropy Range 2";
    private static final Color knot2_def_color = Color.decode("0x0000ff");
    private static final EntropyKnot knot2_def_type = EntropyKnot.X86;
    private static final String KNOT3_COLOR_STRING = "Range 3 color";
    private static final String KNOT3_TYPE_STRING = "Entropy Range 3";
    private static final Color knot3_def_color = Color.decode("0x00ff00");
    private static final EntropyKnot knot3_def_type = EntropyKnot.ASCII;
    private static final String KNOT4_COLOR_STRING = "Range 4 color";
    private static final String KNOT4_TYPE_STRING = "Entropy Range 4";
    private static final Color knot4_def_color = Color.decode("0xffff00");
    private static final EntropyKnot knot4_def_type = EntropyKnot.UTF16;
    private static final String KNOT5_COLOR_STRING = "Range 5 color";
    private static final String KNOT5_TYPE_STRING = "Entropy Range 5";
    private static final Color knot5_def_color = Color.decode("0x0000ff");
    private static final EntropyKnot knot5_def_type = EntropyKnot.NONE;
    private EntropyChunkSize chunksize;
    private Color knot1color;
    private EntropyKnot knot1type;
    private Color knot2color;
    private EntropyKnot knot2type;
    private Color knot3color;
    private EntropyKnot knot3type;
    private Color knot4color;
    private EntropyKnot knot4type;
    private Color knot5color;
    private EntropyKnot knot5type;
    private Palette palette = new Palette(256, uninitializedColor);
    private EntropyOverviewColorService service;

    public EntropyOverviewOptionsManager(PluginTool tool, EntropyOverviewColorService service) {
        this.service = service;
        ToolOptions options = tool.getOptions(OPTIONS_NAME);
        HelpLocation help = new HelpLocation("OverviewPlugin", "EntropyOverviewBar");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        options.setOptionsHelpLocation(help);
        options.registerOption(CHUNKSIZE_STRING, (Object)chunksize_def, help, CHUNKSIZE_DESC_STRING);
        options.registerOption(KNOT1_COLOR_STRING, (Object)knot1_def_color, help, KNOT_COLOR_STRING);
        options.registerOption(KNOT2_COLOR_STRING, (Object)knot2_def_color, help, KNOT_COLOR_STRING);
        options.registerOption(KNOT3_COLOR_STRING, (Object)knot3_def_color, help, KNOT_COLOR_STRING);
        options.registerOption(KNOT4_COLOR_STRING, (Object)knot4_def_color, help, KNOT_COLOR_STRING);
        options.registerOption(KNOT5_COLOR_STRING, (Object)knot5_def_color, help, KNOT_COLOR_STRING);
        options.registerOption(KNOT1_TYPE_STRING, (Object)knot1_def_type, help, KNOT_TYPE_STRING);
        options.registerOption(KNOT2_TYPE_STRING, (Object)knot2_def_type, help, KNOT_TYPE_STRING);
        options.registerOption(KNOT3_TYPE_STRING, (Object)knot3_def_type, help, KNOT_TYPE_STRING);
        options.registerOption(KNOT4_TYPE_STRING, (Object)knot4_def_type, help, KNOT_TYPE_STRING);
        options.registerOption(KNOT5_TYPE_STRING, (Object)knot5_def_type, help, KNOT_TYPE_STRING);
        this.readOptions(options);
        this.updatePalettes();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.readOptions(options);
        this.updatePalettes();
    }

    private void readOptions(ToolOptions options) {
        this.chunksize = (EntropyChunkSize)options.getEnum(CHUNKSIZE_STRING, (Enum)chunksize_def);
        this.knot1color = options.getColor(KNOT1_COLOR_STRING, knot1_def_color);
        this.knot2color = options.getColor(KNOT2_COLOR_STRING, knot2_def_color);
        this.knot3color = options.getColor(KNOT3_COLOR_STRING, knot3_def_color);
        this.knot4color = options.getColor(KNOT4_COLOR_STRING, knot4_def_color);
        this.knot5color = options.getColor(KNOT5_COLOR_STRING, knot5_def_color);
        this.knot1type = (EntropyKnot)options.getEnum(KNOT1_TYPE_STRING, (Enum)knot1_def_type);
        this.knot2type = (EntropyKnot)options.getEnum(KNOT2_TYPE_STRING, (Enum)knot2_def_type);
        this.knot3type = (EntropyKnot)options.getEnum(KNOT3_TYPE_STRING, (Enum)knot3_def_type);
        this.knot4type = (EntropyKnot)options.getEnum(KNOT4_TYPE_STRING, (Enum)knot4_def_type);
        this.knot5type = (EntropyKnot)options.getEnum(KNOT5_TYPE_STRING, (Enum)knot5_def_type);
    }

    private void addPaletteKnot(String name, Color col, double point, double width) {
        int widthint;
        int start;
        int palettewidth = 256;
        int pointint = (int)Math.floor((double)palettewidth / 8.0 * point);
        if (pointint > 255) {
            pointint = 255;
        }
        if ((start = pointint - (widthint = (int)Math.floor((double)palettewidth / 8.0 * width))) < 0) {
            start = 0;
        }
        this.palette.addKnot(name, col, start, pointint);
    }

    private void updatePalettes() {
        this.palette.setBase(Color.decode("0x000000"), Color.decode("0xffffff"));
        this.addPaletteKnots();
        this.service.paletteChanged();
    }

    private void addPaletteKnots() {
        EntropyRecord rec = this.knot1type.getRecord();
        if (rec != null) {
            this.addPaletteKnot(rec.name, this.knot1color, rec.center, rec.width);
        }
        if ((rec = this.knot2type.getRecord()) != null) {
            this.addPaletteKnot(rec.name, this.knot2color, rec.center, rec.width);
        }
        if ((rec = this.knot3type.getRecord()) != null) {
            this.addPaletteKnot(rec.name, this.knot3color, rec.center, rec.width);
        }
        if ((rec = this.knot4type.getRecord()) != null) {
            this.addPaletteKnot(rec.name, this.knot4color, rec.center, rec.width);
        }
        if ((rec = this.knot5type.getRecord()) != null) {
            this.addPaletteKnot(rec.name, this.knot5color, rec.center, rec.width);
        }
    }

    public int getChunkSize() {
        return this.chunksize.getChunkSize();
    }

    public Palette getPalette() {
        return this.palette;
    }
}

