/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.FunctionUtils;
import ghidra.app.plugin.core.navigation.locationreferences.FunctionSignatureFieldLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FieldStringInfo;
import ghidra.app.util.viewer.field.FunctionSignatureFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.app.util.viewer.field.VariableNameFieldFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.FunctionParameterNameFieldLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.ArrayList;

class FunctionParameterNameLocationDescriptor
extends FunctionSignatureFieldLocationDescriptor {
    FunctionParameterNameLocationDescriptor(FunctionLocation location, Program program) {
        super(location, program);
    }

    @Override
    protected void init() {
        this.validate((FunctionLocation)this.programLocation);
        this.homeAddress = this.programLocation.getAddress();
        this.label = this.getVariableName();
    }

    @Override
    protected void validate(FunctionLocation location) {
        if (location == null) {
            throw new NullPointerException("Cannot create a LocationDescriptor from a null ProgramLocation");
        }
        if (!(this.programLocation instanceof FunctionParameterNameFieldLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + this.programLocation);
        }
    }

    protected Variable getVariable() {
        return ((FunctionParameterNameFieldLocation)this.programLocation).getParameter();
    }

    protected String getVariableName() {
        return ((FunctionParameterNameFieldLocation)this.programLocation).getParameterName();
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        Variable variable = this.getVariable();
        if (variable == null) {
            return;
        }
        ReferenceUtils.getVariableReferences(accumulator, this.program, variable);
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        Address currentAddress = this.getAddressForHighlightObject(object);
        if (!this.isInAddresses(currentAddress)) {
            return this.EMPTY_HIGHLIGHTS;
        }
        if (OperandFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            int offset = text.indexOf(this.label);
            if (offset >= 0) {
                return new Highlight[]{new Highlight(offset, this.label.length() + offset - 1, highlightColor)};
            }
        } else if (VariableNameFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            if (this.label.equals(text)) {
                return new Highlight[]{new Highlight(0, text.length() - 1, highlightColor)};
            }
        } else if (FunctionSignatureFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            FieldStringInfo[] parameterStringInfos;
            ArrayList<Highlight> list = new ArrayList<Highlight>();
            Function functionObject = (Function)object;
            for (FieldStringInfo info : parameterStringInfos = FunctionUtils.getFunctionParameterStringInfos(functionObject, text)) {
                String paramString = info.getFieldString();
                String paramName = paramString.split("\\s")[1];
                if (!this.label.equals(paramName)) continue;
                int offset = info.getOffset() + paramString.indexOf(paramName);
                int length = offset + paramName.length() - 1;
                list.add(new Highlight(offset, length, highlightColor));
            }
            return list.toArray(new Highlight[list.size()]);
        }
        return this.EMPTY_HIGHLIGHTS;
    }
}

