/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.action.DockingActionIf;
import ghidra.app.cmd.label.DeleteLabelCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.label.AddLabelAction;
import ghidra.app.plugin.core.label.AllHistoryAction;
import ghidra.app.plugin.core.label.EditExternalLabelAction;
import ghidra.app.plugin.core.label.EditLabelAction;
import ghidra.app.plugin.core.label.LabelHistoryAction;
import ghidra.app.plugin.core.label.OperandLabelDialog;
import ghidra.app.plugin.core.label.RemoveLabelAction;
import ghidra.app.plugin.core.label.SetOperandLabelAction;
import ghidra.app.services.GoToService;
import ghidra.app.util.AddEditDialog;
import ghidra.app.util.EditFieldNameDialog;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import java.awt.Component;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Edit Labels", description="This plugin provides actions and dialogs for adding, removing and editing labels in the code browser", servicesRequired={GoToService.class})
public class LabelMgrPlugin
extends Plugin {
    private OperandLabelDialog operandDialog;
    private AddEditDialog addEditDialog;
    private EditFieldNameDialog editFieldDialog;

    public LabelMgrPlugin(PluginTool tool) {
        super(tool);
        this.setupActions();
    }

    private void setupActions() {
        AddLabelAction addLabelAction = new AddLabelAction(this);
        this.tool.addAction((DockingActionIf)addLabelAction);
        EditLabelAction editLabelAction = new EditLabelAction(this);
        this.tool.addAction((DockingActionIf)editLabelAction);
        EditExternalLabelAction editExternalLabelAction = new EditExternalLabelAction(this);
        this.tool.addAction((DockingActionIf)editExternalLabelAction);
        RemoveLabelAction removeLabelAction = new RemoveLabelAction(this);
        this.tool.addAction((DockingActionIf)removeLabelAction);
        SetOperandLabelAction setOperandLabelAction = new SetOperandLabelAction(this);
        this.tool.addAction((DockingActionIf)setOperandLabelAction);
        LabelHistoryAction labelHistoryAction = new LabelHistoryAction(this.tool, this.getName());
        this.tool.addAction((DockingActionIf)labelHistoryAction);
        AllHistoryAction allHistoryAction = new AllHistoryAction(this.tool, this.getName());
        this.tool.addAction((DockingActionIf)allHistoryAction);
    }

    AddEditDialog getAddEditDialog() {
        if (this.addEditDialog == null) {
            this.addEditDialog = new AddEditDialog("", this.tool);
        }
        return this.addEditDialog;
    }

    EditFieldNameDialog getEditFieldDialog() {
        if (this.editFieldDialog == null) {
            this.editFieldDialog = new EditFieldNameDialog("", this.tool);
        }
        return this.editFieldDialog;
    }

    OperandLabelDialog getOperandLabelDialog() {
        if (this.operandDialog == null) {
            this.operandDialog = new OperandLabelDialog(this);
        }
        return this.operandDialog;
    }

    protected void removeLabelCallback(ListingActionContext context) {
        DeleteLabelCmd cmd;
        Symbol s = this.getSymbol(context);
        if (s != null && !this.tool.execute((Command)(cmd = new DeleteLabelCmd(s.getAddress(), s.getName(), s.getParentNamespace())), (DomainObject)context.getProgram())) {
            this.tool.setStatusInfo(cmd.getStatusMsg());
        }
    }

    protected void addLabelCallback(ListingActionContext context) {
        this.getAddEditDialog().addLabel(context.getAddress(), context.getProgram());
    }

    void editLabelCallback(ListingActionContext context) {
        Symbol s = this.getSymbol(context);
        if (s != null) {
            if (s.getSource() == SourceType.DEFAULT && s.getSymbolType() == SymbolType.CODE) {
                this.getAddEditDialog().addLabel(s.getAddress(), context.getProgram());
            } else {
                this.getAddEditDialog().editLabel(s, context.getProgram());
            }
            return;
        }
        int[] componentPath = context.getLocation().getComponentPath();
        if (componentPath == null || componentPath.length == 0) {
            this.addLabelCallback(context);
            return;
        }
        DataTypeComponent dtComp = LabelMgrPlugin.getComponent(context);
        if (dtComp != null) {
            if (dtComp.getDataType() == DataType.DEFAULT) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getActiveWindow(), (String)"Undefined Field", (Object)"Field data-type must be set prior to editing field name.");
            } else {
                this.getEditFieldDialog().editField(dtComp, context.getProgram());
            }
        }
    }

    void setOperandLabelCallback(ListingActionContext context) {
        this.getOperandLabelDialog().setOperandLabel(context);
    }

    Symbol getSymbol(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        if (location instanceof LabelFieldLocation) {
            LabelFieldLocation lfl = (LabelFieldLocation)location;
            return lfl.getSymbol();
        }
        if (location instanceof OperandFieldLocation) {
            Variable var;
            VariableOffset variableOffset = ((OperandFieldLocation)location).getVariableOffset();
            if (variableOffset != null && (var = variableOffset.getVariable()) != null) {
                return var.getSymbol();
            }
            Reference ref = this.getOperandReference(context);
            if (ref != null) {
                return context.getProgram().getSymbolTable().getSymbol(ref);
            }
        }
        return null;
    }

    private static boolean isInUnion(Data data) {
        for (Data parent = data; parent != null; parent = parent.getParent()) {
            if (!(parent.getDataType() instanceof Union)) continue;
            return true;
        }
        return false;
    }

    static DataTypeComponent getComponent(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        int[] componentPath = location.getComponentPath();
        if (componentPath == null || componentPath.length == 0) {
            return null;
        }
        Data data = context.getProgram().getListing().getDataContaining(location.getAddress());
        if (data == null || !data.isDefined()) {
            return null;
        }
        DataType dt = data.getDataType();
        DataTypeComponent comp = null;
        for (int element : componentPath) {
            if (!(dt instanceof Composite)) {
                return null;
            }
            comp = ((Composite)dt).getComponent(element);
            dt = comp.getDataType();
        }
        return comp;
    }

    static Data getDataComponent(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        int[] componentPath = location.getComponentPath();
        if (componentPath == null || componentPath.length == 0) {
            return null;
        }
        Data data = context.getProgram().getListing().getDataContaining(location.getAddress());
        if (data == null || !data.isDefined()) {
            return null;
        }
        return data.getComponent(componentPath);
    }

    boolean isOnSymbol(ListingActionContext context) {
        return this.getSymbol(context) != null;
    }

    boolean isOnFunction(ListingActionContext context) {
        return context.getLocation() instanceof FunctionLocation;
    }

    boolean isOnVariableReference(ListingActionContext context) {
        Symbol s = this.getSymbol(context);
        if (s == null) {
            return false;
        }
        SymbolType type = s.getSymbolType();
        return type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR;
    }

    boolean isOnExternalReference(ListingActionContext context) {
        Symbol s = this.getSymbol(context);
        if (s == null) {
            return false;
        }
        return s.isExternal();
    }

    boolean hasLabelHistory(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        Address addr = null;
        if (location instanceof CodeUnitLocation) {
            CodeUnitLocation loc = (CodeUnitLocation)location;
            addr = loc.getAddress();
        } else if (location instanceof OperandFieldLocation) {
            Address a = ((OperandFieldLocation)location).getRefAddress();
            addr = a == null ? addr : a;
        }
        SymbolTable st = context.getProgram().getSymbolTable();
        return st.hasLabelHistory(addr);
    }

    private Reference getOperandReference(ListingActionContext context) {
        if (!(context.getLocation() instanceof OperandFieldLocation)) {
            return null;
        }
        OperandFieldLocation opLoc = (OperandFieldLocation)context.getLocation();
        Address address = opLoc.getAddress();
        int opIndex = opLoc.getOperandIndex();
        Data dataComp = LabelMgrPlugin.getDataComponent(context);
        if (dataComp != null) {
            if (LabelMgrPlugin.isInUnion(dataComp)) {
                return null;
            }
            address = dataComp.getMinAddress();
        }
        ReferenceManager refMgr = context.getProgram().getReferenceManager();
        return refMgr.getPrimaryReferenceFrom(address, opIndex);
    }
}

