/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.gotoquery.GoToHelper;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.app.services.CodeFormatService;
import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.util.bean.opteditor.OptionsVetoException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public abstract class AbstractReferenceHover
extends AbstractConfigurableHover {
    public static final int WINDOW_OFFSET = 50;
    protected static final Color BACKGROUND_COLOR = new Color(255, 255, 230);
    protected CodeFormatService codeFormatService;
    protected ListingPanel panel;
    protected JToolTip toolTip;
    protected ProgramLocation previewLocation;
    protected GoToHelper gotoHelper;

    public AbstractReferenceHover(PluginTool tool, int priority) {
        this(tool, null, priority);
    }

    protected AbstractReferenceHover(PluginTool tool, CodeFormatService codeFormatService, int priority) {
        super(tool, priority);
        this.codeFormatService = codeFormatService;
        this.initialize();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.panel != null) {
            this.panel.dispose();
            this.panel = null;
        }
        if (this.gotoHelper != null) {
            this.gotoHelper.dispose();
            this.gotoHelper = null;
        }
    }

    private void initialize() {
        this.gotoHelper = new GoToHelper(this.tool);
    }

    @Override
    public void setOptions(Options options, String name) {
        this.enabled = options.getBoolean(name, true);
        int dialogWidth = options.getInt(name + ".Dialog Width", 600);
        if (dialogWidth <= 0) {
            throw new OptionsVetoException("Reference Code Viewer Dialog Width must be greater than 0");
        }
        int dialogHeight = options.getInt(name + ".Dialog Height", 400);
        if (dialogHeight <= 0) {
            throw new OptionsVetoException("Reference Code Viewer Dialog Height must be greater than 0");
        }
        Dimension d = new Dimension(dialogWidth, dialogHeight);
        if (this.panel != null) {
            this.panel.setPreferredSize(d);
        }
    }

    protected void initializeLazily() {
        if (this.panel != null) {
            return;
        }
        if (this.tool == null) {
            return;
        }
        if (this.codeFormatService == null) {
            this.codeFormatService = (CodeFormatService)this.tool.getService(CodeFormatService.class);
        }
        if (this.codeFormatService == null) {
            return;
        }
        this.panel = new ListingPanel(this.codeFormatService.getFormatManager());
        this.panel.setTextBackgroundColor(BACKGROUND_COLOR);
        this.toolTip = new JToolTip();
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        boolean toolTipForLocation;
        this.initializeLazily();
        if (!this.enabled || programLocation == null || this.panel == null) {
            return null;
        }
        this.panel.setProgram(program);
        Address refAddr = programLocation.getRefAddress();
        if (refAddr != null && refAddr.isExternalAddress()) {
            return this.createExternalToolTipComponent(program, refAddr);
        }
        this.previewLocation = this.getPreviewLocation(program, programLocation, programLocation.getRefAddress());
        if (this.previewLocation != null && (toolTipForLocation = this.panel.goTo(this.previewLocation))) {
            Rectangle bounds = this.panel.getBounds();
            bounds.x = 50;
            bounds.y = 50;
            this.panel.setBounds(bounds);
            return this.panel;
        }
        this.panel.setProgram(null);
        return null;
    }

    protected JComponent createExternalToolTipComponent(Program program, Address extAddr) {
        Symbol s = program.getSymbolTable().getPrimarySymbol(extAddr);
        if (s == null) {
            return null;
        }
        ExternalLocation extLoc = null;
        Function extFunc = null;
        Object obj = s.getObject();
        if (obj instanceof Function) {
            extFunc = (Function)obj;
            extLoc = extFunc.getExternalLocation();
        } else if (obj instanceof ExternalLocation) {
            extLoc = (ExternalLocation)obj;
        } else {
            return null;
        }
        this.toolTip.setTipText(ToolTipUtils.getToolTipText(extLoc, true));
        return this.toolTip;
    }

    public void programClosed(Program program) {
        if (this.panel != null && this.panel.getProgram() == program) {
            this.panel.setProgram(null);
        }
    }

    @Override
    public void componentHidden() {
        if (this.panel != null) {
            this.panel.setProgram(null);
        }
    }

    @Override
    public void componentShown() {
        if (this.panel != null && this.previewLocation != null) {
            this.panel.goTo(this.previewLocation);
        }
    }

    protected ProgramLocation getPreviewLocation(Program program, ProgramLocation pLoc, Address toAddress) {
        if (toAddress == null || pLoc == null) {
            return null;
        }
        ProgramLocation location = this.gotoHelper.getLocation(program, pLoc.getAddress(), toAddress);
        if (location != null) {
            return location;
        }
        if (pLoc instanceof OperandFieldLocation && toAddress.isVariableAddress()) {
            Variable var;
            OperandFieldLocation opLoc = (OperandFieldLocation)pLoc;
            ReferenceManager refMgr = program.getReferenceManager();
            Reference ref = refMgr.getReference(opLoc.getAddress(), toAddress, opLoc.getOperandIndex());
            if (ref != null && (var = refMgr.getReferencedVariable(ref)) != null) {
                return new VariableNameFieldLocation(program, var, 0);
            }
        }
        return null;
    }

    @Override
    public void scroll(int amount) {
        if (this.panel != null) {
            this.panel.getFieldPanel().scrollView(amount);
        }
    }
}

