/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.equate.EquateReferenceRenderer;
import ghidra.app.plugin.core.equate.EquateReferenceTableModel;
import ghidra.app.plugin.core.equate.EquateRenderer;
import ghidra.app.plugin.core.equate.EquateTableModel;
import ghidra.app.plugin.core.equate.EquateTablePlugin;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.util.HelpLocation;
import ghidra.util.UniversalID;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.SelectionNavigationAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import resources.ResourceManager;

public class EquateTableProvider
extends ComponentProviderAdapter {
    private static final String DELETE_IMAGE = "images/edit-delete.png";
    private EquateTablePlugin plugin;
    private GhidraTable equatesTable;
    private EquateTableModel equatesModel;
    private GhidraTable referencesTable;
    private EquateReferenceTableModel referencesModel;
    private DockingAction deleteAction;
    private JPanel mainPanel;
    private GhidraTableFilterPanel<Equate> equatesFilterPanel;

    EquateTableProvider(EquateTablePlugin plugin) {
        super(plugin.getTool(), "Equates Table", plugin.getName(), ProgramActionContext.class);
        this.setHelpLocation(new HelpLocation("EquatePlugin", "Equate Table"));
        this.plugin = plugin;
        this.mainPanel = this.createWorkPanel();
        this.addToTool();
        this.createAction();
    }

    public void closeComponent() {
        super.closeComponent();
        this.plugin.componentClosed();
    }

    public void componentShown() {
        this.plugin.componentShown();
        this.updateEquates();
    }

    public ActionContext getActionContext(MouseEvent event) {
        Program program = this.plugin.getProgram();
        if (program == null) {
            return null;
        }
        if (event != null && event.getSource() == this.referencesTable) {
            return new ProgramActionContext((ComponentProvider)this, program, (Object)this.referencesTable);
        }
        return new ProgramActionContext((ComponentProvider)this, program, (Object)this.equatesTable);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    void programOpened(Program program) {
        this.equatesModel.update();
        this.referencesModel.setEquate(null);
    }

    void programClosed() {
        this.equatesModel.update();
        this.referencesModel.setEquate(null);
    }

    void updateEquates() {
        int row = this.equatesTable.getSelectedRow();
        this.equatesModel.update();
        int rows = this.equatesTable.getRowCount();
        if (row < 0 || row >= rows) {
            row = 0;
        }
        if (rows > 0) {
            this.equatesTable.setRowSelectionInterval(row, row);
        }
        this.handleEquateTableSelection();
    }

    void showEquates() {
        this.tool.showComponentProvider((ComponentProvider)this, true);
    }

    void dispose() {
        this.removeFromTool();
        this.equatesFilterPanel.dispose();
        this.referencesTable.dispose();
    }

    GhidraTable getReferencesTable() {
        return this.referencesTable;
    }

    GhidraTable getEquatesTable() {
        return this.equatesTable;
    }

    private JPanel createWorkPanel() {
        this.equatesModel = new EquateTableModel(this.plugin);
        this.equatesTable = new GhidraTable((TableModel)((Object)this.equatesModel));
        this.equatesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EquateTableProvider.this.handleEquateTableSelection();
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 33 || e.getKeyCode() == 34) {
                    EquateTableProvider.this.handleEquateTableSelection();
                }
            }
        });
        this.equatesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DataTypeManager dtm = EquateTableProvider.this.plugin.getProgram().getDataTypeManager();
                    Object obj = evt.getSource();
                    if (obj instanceof GhidraTable) {
                        GhidraTable table = (GhidraTable)((Object)obj);
                        int row = table.rowAtPoint(evt.getPoint());
                        int column = table.columnAtPoint(evt.getPoint());
                        if (column != 0) {
                            return;
                        }
                        DataTypeManagerService dtms = (DataTypeManagerService)EquateTableProvider.this.tool.getService(DataTypeManagerService.class);
                        if (dtms == null) {
                            return;
                        }
                        Equate equate = (Equate)table.getValueAt(row, column);
                        UniversalID id = new UniversalID(Long.parseLong(equate.getName().split(":")[1]));
                        Enum enoom = (Enum)dtm.findDataTypeForID(id);
                        if (enoom != null) {
                            dtms.edit((DataType)enoom);
                        } else {
                            EquateTableProvider.this.showDeleteEquateOptionDialog();
                        }
                    }
                }
            }
        });
        this.equatesTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.handleEquateTableSelection();
        });
        this.equatesTable.setAutoResizeMode(4);
        this.equatesTable.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.equatesTable.setRowSelectionAllowed(true);
        this.equatesTable.setSelectionMode(0);
        this.equatesFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.equatesTable), this.equatesModel);
        JScrollPane equatesTablePane = new JScrollPane((Component)((Object)this.equatesTable));
        this.setEquateTableRenderer();
        JPanel equatesPanel = new JPanel(new BorderLayout());
        equatesPanel.add((Component)new JLabel("Equates", 0), "North");
        equatesPanel.add((Component)equatesTablePane, "Center");
        equatesPanel.add((Component)((Object)this.equatesFilterPanel), "South");
        this.referencesModel = new EquateReferenceTableModel(this.plugin);
        this.referencesTable = new GhidraTable((TableModel)((Object)this.referencesModel));
        this.referencesTable.setAutoResizeMode(4);
        this.referencesTable.setPreferredScrollableViewportSize(new Dimension(250, 150));
        this.referencesTable.setRowSelectionAllowed(true);
        this.referencesTable.setSelectionMode(0);
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        if (goToService != null) {
            this.referencesTable.installNavigation(goToService, goToService.getDefaultNavigatable());
        }
        JScrollPane referencesTablePane = new JScrollPane((Component)((Object)this.referencesTable));
        JTableHeader referencesHeader = this.referencesTable.getTableHeader();
        referencesHeader.setUpdateTableInRealTime(true);
        this.setReferenceTableRenderer();
        JPanel referencesPanel = new JPanel(new BorderLayout());
        referencesPanel.add((Component)new JLabel("References", 0), "North");
        referencesPanel.add((Component)referencesTablePane, "Center");
        JPanel workPanel = new JPanel(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, equatesPanel, referencesPanel);
        splitPane.setResizeWeight(0.5);
        workPanel.add((Component)splitPane, "Center");
        return workPanel;
    }

    private void handleEquateTableSelection() {
        Equate equate = (Equate)this.equatesFilterPanel.getSelectedItem();
        this.referencesTable.clearSelection();
        this.referencesModel.setEquate(equate);
    }

    private void setEquateTableRenderer() {
        for (int i = 0; i < this.equatesModel.getColumnCount(); ++i) {
            TableColumn column = this.equatesTable.getColumnModel().getColumn(i);
            column.setCellRenderer((TableCellRenderer)((Object)new EquateRenderer(this)));
        }
    }

    private void setReferenceTableRenderer() {
        for (int i = 0; i < this.referencesModel.getColumnCount(); ++i) {
            TableColumn column = this.referencesTable.getColumnModel().getColumn(i);
            column.setCellRenderer((TableCellRenderer)((Object)new EquateReferenceRenderer()));
        }
    }

    private void createAction() {
        ImageIcon deleteImage = ResourceManager.loadImage((String)DELETE_IMAGE);
        this.deleteAction = new DockingAction("Delete Equate", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EquateTableProvider.this.delete();
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (context.getContextObject() == EquateTableProvider.this.equatesTable) {
                    return super.isEnabledForContext(context);
                }
                return false;
            }
        };
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, (Icon)deleteImage));
        this.deleteAction.setToolBarData(new ToolBarData((Icon)deleteImage));
        this.deleteAction.setDescription("Delete an Equate");
        this.deleteAction.setHelpLocation(new HelpLocation("EquatePlugin", "Delete Equate"));
        SelectionNavigationAction selectionNavigationAction = new SelectionNavigationAction(this.plugin, this.referencesTable);
        selectionNavigationAction.setHelpLocation(new HelpLocation("Search", "Selection_Navigation"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.deleteAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)selectionNavigationAction);
    }

    private void delete() {
        List equates = this.equatesFilterPanel.getSelectedItems();
        TableCellEditor cellEditor = this.equatesTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        this.plugin.deleteEquates(equates);
    }

    void setGoToService(GoToService service) {
        if (service != null) {
            this.referencesTable.installNavigation(service, service.getDefaultNavigatable());
        } else {
            this.referencesTable.removeNavigation();
        }
    }

    private void showDeleteEquateOptionDialog() {
        String message = "Data type not found. Would you like to delete this equate?";
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(this.equatesFilterPanel, (String)"Delete Equate", (String)message, (String)"Delete Equate", (int)0);
        if (choice == 1) {
            this.delete();
        }
    }

    EquateTableModel getEquatesModel() {
        return this.equatesModel;
    }

    Program getProgram() {
        return this.plugin.getProgram();
    }
}

